# Activity Diagram (PlantUML)

Berikut adalah representasi Activity Diagram untuk 3 proses utama dalam sistem.

## 1. Pengunjung Mengisi Formulir Doa

```plantuml
@startuml
title Pengunjung Mengisi Formulir Doa

start
:Akses Halaman Formulir;
:Pilih Formulir Doa;
repeat :Isi Data (Nama, Telepon, Email, \nKategori, Permohonan, Privasi);
    :Klik Submit;
    backward:Tampilkan Pesan Error;
repeat while (Data Valid?) is (Tidak)
-> Ya;
:Simpan ke Database;
:Tampilkan Pesan Sukses;
stop
@enduml
```

## 2. Admin Mengelola Jadwal Ibadah

```plantuml
@startuml
title Admin Mengelola Jadwal Ibadah

start
repeat :Admin Login;
repeat while (Login Valid?) is (Tidak)
-> Ya;
:Akses Dashboard;
:Pilih Menu Jadwal Ibadah;
:Lihat Daftar Jadwal;

switch (Pilih Aksi?)
case ( Tambah )
    :Tampilkan Form Baru;
    :Input Data Jadwal;
    :Simpan;
case ( Edit )
    :Pilih Jadwal;
    :Tampilkan Form Edit;
    :Update Data;
    :Update;
case ( Hapus )
    :Pilih Jadwal;
    :Konfirmasi Hapus;
    :Delete;
endswitch

:Update Database;
:Tampilkan Notif Sukses;
stop
@enduml
```

```

```

## 3. Admin: Lihat Dashboard

```plantuml
@startuml
title Admin - Lihat Dashboard
skinparam nodesep 100
skinparam ranksep 75

start
:Masuk Halaman Login;
if (Login Valid?) then (Ya)
    :Masuk Dashboard;
    fork

        :Lihat Statistik Jemaat;
    fork again
        :Lihat Jadwal Terdekat;
    fork again
        :Lihat Ringkasan Keuangan;
    end fork
else (Tidak)
    :Tampilkan Pesan Error;
    detach
endif
stop
@enduml
```

## 4. Admin: Kelola OIG & Kegiatan

```plantuml
@startuml
title Admin - Kelola OIG & Kegiatan
skinparam nodesep 100
skinparam ranksep 75

start
:Pilih Menu OIG / Kegiatan;
:Lihat Daftar;

switch (Pilih Aksi?)
case ( Tambah )
    :Input Data Baru;
    note right: Upload Foto/Dokumentasi;
    :Simpan;
case ( Edit )
    :Pilih Item;
    :Edit Data;
    :Update;
case ( Hapus )
    :Pilih Item;
    :Konfirmasi;
    :Delete;
endswitch

:Update Database;
stop
@enduml
```

## 5. Admin: Kelola Berita & Pengumuman

```plantuml
@startuml
title Admin - Kelola Berita & Pengumuman
skinparam nodesep 100
skinparam ranksep 75

start
:Pilih Menu Berita / Pengumuman;
:Lihat Daftar;

split
    :Tambah Berita/Pengumuman;
    :Input Judul & Konten;
    :Set Status (Draft/Publish);
split again
    :Edit Item;
    :Update Konten;
end split

:Simpan Perubahan;
stop
@enduml
```

## 6. Admin: Kelola Data Jemaat

```plantuml
@startuml
!theme plain
title Admin - Kelola Data Jemaat
skinparam nodesep 100
skinparam ranksep 75

start
:Pilih Menu Jemaat;
:Lihat Tabel Jemaat;
:Cari / Filter Data;

if (Tambah Jemaat Baru?) then (Ya)
    :Input Data Pribadi;
    :Input Data Keluarga;
    :Simpan;
else (Edit Jemaat Existing)
    :Pilih Anggota;
    :Edit Data;
    :Simpan;
endif

:Update Database;
stop
@enduml
```

## 7. Admin: Kelola Formulir & Pesan

```plantuml
@startuml
!theme plain
title Admin - Kelola Formulir & Pesan
skinparam nodesep 100
skinparam ranksep 75

start
:Pilih Menu Formulir / Pesan;
:Lihat Daftar Masuk;

if (Tipe Item?) then (Pesan Kontak)
    :Baca Pesan;
    :Balas via Email (Optional);
    :Tandai Dibaca;
else (Formulir Pelayanan)
    :Review Pengajuan;
    :Ubah Status;
    note right: Pending -> Dikonfirmasi;
endif

:Simpan Perubahan;
stop
@enduml
```

## 8. Admin: Kelola Keuangan & Donasi

```plantuml
@startuml
!theme plain
title Admin - Kelola Keuangan & Donasi
skinparam nodesep 100
skinparam ranksep 75

start
:Pilih Menu Keuangan;

split
    :Input Transaksi;
    note right: Pemasukan / Pengeluaran;
split again
    :Verifikasi Donasi;
    if (Bukti Valid?) then (Ya)
        :Konfirmasi;
    else (Tidak)
        :Tolak / Pendings;
    endif
split again
    :Cetak Laporan;
    :Pilih Periode;
    :Export PDF/Excel;
end split

:Simpan / Generate;
stop
@enduml
```

## 9. Admin: Kelola Pengguna Sistem

```plantuml
@startuml
!theme plain
title Admin - Kelola Pengguna Sistem
skinparam nodesep 100
skinparam ranksep 75

start
:Pilih Menu User;
:Lihat Daftar User;

if (Aksi?) then (Tambah Admin/Pendeta)
    :Input Nama & Email;
    :Set Role;
    :Generate Password;
else (Reset Password)
    :Pilih User;
    :Reset Password;
endif

:Simpan User;
stop
@enduml
```

## 10. Pendeta Mengelola Formulir Konseling

```plantuml
@startuml
!theme plain
title Pendeta Mengelola Formulir Konseling

start
:Pendeta Login;
:Akses Dashboard Pendeta;
:Pilih Menu Formulir;
:Pilih Tab Konseling;
:Lihat Daftar Pengajuan;
:Pilih Pengajuan Spesifik;

split
    :Ubah Status;
    note right
        Opsi:
        - Pending
        - Dijadwalkan
        - Selesai
        - Batal
    end note
split again
    :Kelola Catatan;
    note right
        - Tambah Catatan
        - Edit Catatan
    end note
end split

:Simpan Perubahan;
stop
@enduml
```

---

# Activity Diagram (Mermaid)

Berikut adalah versi Mermaid JS dari diagram di atas.

## 1. Pengunjung Mengisi Formulir Doa

```mermaid
stateDiagram-v2
    [*] --> Akses_Halaman_Formulir
    Akses_Halaman_Formulir --> Pilih_Formulir_Doa
    Pilih_Formulir_Doa --> Isi_Data

    state "Isi Data (Nama, Telepon, Email...)" as Isi_Data
    state "Klik Submit" as Klik_Submit
    state "Tampilkan Pesan Error" as Pesan_Error
    state check_valid <<choice>>

    Isi_Data --> Klik_Submit
    Klik_Submit --> check_valid
    check_valid --> Pesan_Error : Data Tidak Valid
    Pesan_Error --> Isi_Data
    check_valid --> Simpan_ke_Database : Data Valid

    Simpan_ke_Database --> Tampilkan_Pesan_Sukses
    Tampilkan_Pesan_Sukses --> [*]
```

## 2. Admin Mengelola Jadwal Ibadah

```mermaid
stateDiagram-v2
    [*] --> Admin_Login
    state login_check <<choice>>
    
    Admin_Login --> login_check
    login_check --> Admin_Login : Login Gagal
    login_check --> Akses_Dashboard : Login Berhasil

    Akses_Dashboard --> Pilih_Menu_Jadwal
    Pilih_Menu_Jadwal --> Lihat_Daftar_Jadwal
    
    state pilih_aksi <<choice>>
    Lihat_Daftar_Jadwal --> pilih_aksi
    
    pilih_aksi --> Tambah_Jadwal : Tambah
    pilih_aksi --> Edit_Jadwal : Edit
    pilih_aksi --> Hapus_Jadwal : Hapus

    state "Tampilkan Form Baru" as Form_Baru
    state "Input Data Jadwal" as Input_Jadwal
    
    Tambah_Jadwal --> Form_Baru
    Form_Baru --> Input_Jadwal
    Input_Jadwal --> Simpan

    state "Pilih Jadwal" as Pilih_Edit
    state "Tampilkan Form Edit" as Form_Edit
    state "Update Data" as Update_Data

    Edit_Jadwal --> Pilih_Edit
    Pilih_Edit --> Form_Edit
    Form_Edit --> Update_Data
    Update_Data --> Update

    state "Pilih Jadwal" as Pilih_Hapus
    state "Konfirmasi Hapus" as Konfirm_Hapus

    Hapus_Jadwal --> Pilih_Hapus
    Pilih_Hapus --> Konfirm_Hapus
    Konfirm_Hapus --> Delete

    Simpan --> Update_Database
    Update --> Update_Database
    Delete --> Update_Database

    Update_Database --> Tampilkan_Notif
    Tampilkan_Notif --> [*]
```

## 3. Pendeta Mengelola Formulir Konseling

```mermaid
stateDiagram-v2
    [*] --> Pendeta_Login
    Pendeta_Login --> Akses_Dashboard_Pendeta
    Akses_Dashboard_Pendeta --> Pilih_Menu_Formulir
    Pilih_Menu_Formulir --> Pilih_Tab_Konseling
    Pilih_Tab_Konseling --> Lihat_Daftar_Pengajuan
    Lihat_Daftar_Pengajuan --> Pilih_Pengajuan_Spesifik

    state fork_state <<fork>>
    Pilih_Pengajuan_Spesifik --> fork_state
    
    fork_state --> Ubah_Status
    note right of Ubah_Status
        Opsi: Pending, Dijadwalkan, Selesai, Batal
    end note

    fork_state --> Kelola_Catatan
    note right of Kelola_Catatan
        Tambah atau Edit Catatan
    end note

    state join_state <<join>>
    Ubah_Status --> join_state
    Kelola_Catatan --> join_state

    join_state --> Simpan_Perubahan
    Simpan_Perubahan --> [*]
```

