# Panduan Instalasi Aplikasi (Gereja Buntu Ambaang)

Berikut adalah langkah-langkah untuk menginstal dan menjalankan aplikasi ini di komputer lokal Anda.

## Prasyarat

Pastikan Anda telah menginstal perangkat lunak berikut di komputer Anda:

1.  **PHP** (Versi 8.2 atau yang lebih baru)
2.  **Composer** (Manajer paket untuk PHP)
3.  **Node.js** & **NPM** (Untuk mengelola aset frontend)

## Langkah-langkah Instalasi

### 1. Dapatkan Kode Sumber
Jika Anda belum memilikinya, clone repositori ini atau ekstrak file zip ke direktori yang diinginkan.

```bash
git clone <url-repository-anda>
cd gereja-buntu-ambaang
```

### 2. Instal Dependensi PHP
Jalankan perintah berikut untuk menginstal semua library PHP yang dibutuhkan menggunakan Composer:

```bash
composer install
```

### 3. Konfigurasi Environment (.env)
Salin file konfigurasi contoh `.env.example` menjadi `.env`:

```bash
cp .env.example .env
```
*(Di Windows, Anda bisa menggunakan `copy .env.example .env` atau melakukannya secara manual lewat File Explorer)*

### 4. Generate Application Key
Aplikasi Laravel membutuhkan kunci enkripsi unik. Generate kunci tersebut dengan perintah:

```bash
php artisan key:generate
```

### 5. Konfigurasi Database (MySQL)
Secara default, aplikasi ini dikonfigurasi menggunakan **MySQL**.

1.  Pastikan file `.env` Anda memiliki konfigurasi berikut (sesuaikan dengan credential database lokal Anda):
    ```ini
    DB_CONNECTION=mysql
    DB_HOST=127.0.0.1
    DB_PORT=3306
    DB_DATABASE=gereja_buntu_ambaang
    DB_USERNAME=root
    DB_PASSWORD=
    ...
    ```
2.  Buat database baru bernama `gereja_buntu_ambaang` di MySQL Anda (bisa menggunakan phpMyAdmin, TablePlus, atau terminal).
    ```sql
    CREATE DATABASE gereja_buntu_ambaang;
    ```

3.  Jalankan migrasi database untuk membuat tabel:
    ```bash
    php artisan migrate
    ```

### 6. Mengisi Data Awal (Seeding)
Untuk mengisi database dengan data awal (termasuk akun admin contoh), jalankan perintah berikut:

```bash
php artisan db:seed
```

Data yang akan dibuat meliputi:
- Akun Admin dan Pendeta
- Contoh Jadwal Ibadah
- Contoh Data Keuangan
- Contoh Data Jemaat

### 7. Instal Dependensi Frontend
Instal dependensi JavaScript dan build aset frontend:

```bash
npm install
npm run build
```

## Menjalankan Aplikasi

Anda perlu menjalankan dua perintah di terminal yang berbeda (atau tab terpisah) agar aplikasi berjalan sepenuhnya.

**Terminal 1: Menjalankan Server Laravel**
```bash
php artisan serve
```
Aplikasi akan dapat diakses di `http://127.0.0.1:8000` (atau port lain yang ditampilkan).

**Terminal 2: Menjalankan Vite (untuk aset frontend hot-reload)**
```bash
npm run dev
```

## Akun Default
Setelah menjalankan seeder (`php artisan db:seed`), Anda dapat masuk menggunakan akun berikut:

| Role | Email | Password |
| :--- | :--- | :--- |
| **Admin** | `admin@gereja.org` | `password123` |
| **Pendeta** | `pendeta@gereja.org` | `password123` |

Pastikan untuk mengganti password ini jika aplikasi akan digunakan di lingkungan produksi.
