# Ringkasan Sistem Informasi Gereja Buntu Ambaang

## Deskripsi Sistem
Sistem Informasi Gereja Buntu Ambaang adalah aplikasi berbasis web yang dibangun menggunakan framework Laravel. Sistem ini bertujuan untuk membantu pengelolaan data gereja termasuk jadwal ibadah, kegiatan, keuangan, data jemaat, formulir pelayanan, dan komunikasi.

---

## 1. Use Case Diagram

### Diagram Use Case (ASCII Revisi)

Berikut adalah representasi Use Case Diagram dengan layout vertikal untuk memastikan tampilan tetap rapi di berbagai perangkat.

#### Aktor: PENGUNJUNG (Public) dan ADMIN

```
      PENGUNJUNG                                               ADMIN
          O                                                      O
         /|\                                                    /|\
         / \                                                    / \
          |                                                      |
    .-------------------.                                        |
    |  SISTEM GEREJA    |                                        |
    |-------------------|                                        |
    | ( Lihat Beranda ) |                                        |
    | ( Lihat Jadwal  ) |                                        |
    | ( Lihat O.I.G.  ) |                                        |
    | ( Lihat Kegiatan) |                                        |
    | ( Lihat Berita  ) |                                        |
    | ( Isi Form Doa  ) |<------------------------+              |
    | ( Daftar Giat   ) |                         |              |
    | ( Konseling     ) |<------------------------+              |
    | ( Konfirm Donasi) |<------------------------|--------------+
    | ( Kontak Kami   ) |<------------------------|--------------+
    |                   |                         |              |
    | (     LOGIN     ) |<------------------------|--------------+
    | ( Kelola Jadwal ) |<------------------------|--------------+
    | ( Kelola O.I.G  ) |<------------------------|--------------+
    | ( Kelola Giat   ) |<------------------------|--------------+
    | ( Kelola Berita ) |<------------------------|--------------+
    | ( Kelola Umum   ) |<------------------------|--------------+
    | ( Kelola Uang   ) |<------------------------|--------------+
    | ( Kelola Donasi ) |<------------------------|--------------+
    | ( Kelola User   ) |<------------------------|--------------+
    | ( Kelola Jemaat ) |<------------------------|--------------+
    | ( Kelola Profil ) |<------------------------|--------------+
    | ( Kelola Pesan  ) |<------------------------+--------------+
    '-------------------'
```

#### Aktor: PENDETA (Akses Khusus)

```
                            PENDETA
                               O
                              /|\
                              / \
                               |
                        .-------------.
                        | SISTEM (KH) |
                        |-------------|
                        | ( Dashboard )
                        | ( Data Jemaat)
                        | ( Form Doa   )
                        | ( Form Konsel)
                        '-------------'
```

**Keterangan Simbol:**
- **O /|\ / \** : Aktor (Pengguna Sistem)
- **( ... )** : Use Case (Fungsi Sistem)
- **<---** : Garis Asosiasi (Aktor dapat mengakses fungsi)



---

### Diagram Use Case (Mermaid)

```mermaid
useCaseDiagram
    actor "Pengunjung" as P
    actor "Admin" as A
    actor "Pendeta" as Pd

    package "Sistem Informasi Gereja" {
        usecase "Lihat Beranda" as U1
        usecase "Lihat Jadwal Ibadah" as U2
        usecase "Lihat OIG" as U3
        usecase "Lihat Kegiatan" as U4
        usecase "Lihat Berita" as U5
        usecase "Lihat Profil" as U6
        usecase "Lihat Laporan Keuangan" as U7
        usecase "Isi Formulir Doa" as U8
        usecase "Isi Formulir Pendaftaran" as U9
        usecase "Isi Formulir Konseling" as U10
        usecase "Konfirmasi Donasi" as U11
        usecase "Kirim Pesan Kontak" as U12
        usecase "Login" as U13
        usecase "Kelola Jadwal" as U14
        usecase "Kelola OIG" as U15
        usecase "Kelola Kegiatan" as U16
        usecase "Kelola Berita" as U17
        usecase "Kelola Pengumuman" as U18
        usecase "Kelola Kalender" as U19
        usecase "Kelola Formulir" as U20
        usecase "Kelola Keuangan" as U21
        usecase "Kelola Donasi" as U22
        usecase "Kelola User" as U23
        usecase "Kelola Jemaat" as U24
        usecase "Kelola Profil" as U25
        usecase "Kelola Pesan" as U26
        usecase "Lihat Dashboard" as U27
        usecase "Lihat Data Jemaat" as U28
    }

    P --> U1
    P --> U2
    P --> U3
    P --> U4
    P --> U5
    P --> U6
    P --> U7
    P --> U8
    P --> U9
    P --> U10
    P --> U11
    P --> U12
    P --> U13

    A --> U13
    A --> U14
    A --> U15
    A --> U16
    A --> U17
    A --> U18
    A --> U19
    A --> U20
    A --> U21
    A --> U22
    A --> U23
    A --> U24
    A --> U25
    A --> U26
    A --> U27

    Pd --> U13
    Pd --> U27
    Pd --> U28
    Pd --> U26
```

### Diagram Use Case (PlantUML)

```plantuml
@startuml
left to right direction
actor "Pengunjung" as P
actor "Admin" as A
actor "Pendeta" as Pd

rectangle "Sistem Informasi Gereja" {
  usecase "Lihat Beranda" as U1
  usecase "Lihat Jadwal Ibadah" as U2
  usecase "Lihat OIG" as U3
  usecase "Lihat Kegiatan" as U4
  usecase "Lihat Berita" as U5
  usecase "Lihat Profil" as U6
  usecase "Lihat Laporan Keuangan" as U7
  usecase "Isi Formulir Doa" as U8
  usecase "Isi Formulir Pendaftaran" as U9
  usecase "Isi Formulir Konseling" as U10
  usecase "Konfirmasi Donasi" as U11
  usecase "Kirim Pesan Kontak" as U12
  usecase "Login" as U13
  usecase "Kelola Jadwal" as U14
  usecase "Kelola OIG" as U15
  usecase "Kelola Kegiatan" as U16
  usecase "Kelola Berita" as U17
  usecase "Kelola Pengumuman" as U18
  usecase "Kelola Kalender" as U19
  usecase "Kelola Formulir" as U20
  usecase "Kelola Keuangan" as U21
  usecase "Kelola Donasi" as U22
  usecase "Kelola User" as U23
  usecase "Kelola Jemaat" as U24
  usecase "Kelola Profil" as U25
  usecase "Kelola Pesan" as U26
  usecase "Lihat Dashboard" as U27
  usecase "Lihat Data Jemaat" as U28
}

P --> U1
P --> U2
P --> U3
P --> U4
P --> U5
P --> U6
P --> U7
P --> U8
P --> U9
P --> U10
P --> U11
P --> U12
P --> U13

A --> U13
A --> U14
A --> U15
A --> U16
A --> U17
A --> U18
A --> U19
A --> U20
A --> U21
A --> U22
A --> U23
A --> U24
A --> U25
A --> U26
A --> U27

Pd --> U13
Pd --> U27
Pd --> U28
Pd --> U26
@enduml
```

---


### Tabel Aktor

### a. Pengunjung

| Komponen | Keterangan |
|----------|------------|
| **Actor** | Pengunjung |
| **Brief Description** | Pengunjung (Public) adalah pengguna umum yang dapat mengakses website gereja tanpa perlu login. Pengunjung dapat melihat informasi gereja dan mengisi formulir yang tersedia. |
| **Main Flow** | Pengunjung mengakses halaman beranda website gereja. Dari beranda, pengunjung dapat melihat jadwal ibadah mingguan, informasi OIG (Organisasi Intra Gereja), kegiatan gereja, kalender acara, berita terbaru, profil gereja, dan laporan keuangan publik. Pengunjung dapat mengisi formulir permohonan doa dengan menyertakan nama, telepon, email, kategori doa, dan permohonan. Pengunjung juga dapat mendaftar kegiatan melalui formulir pendaftaran, mengajukan konseling melalui formulir konseling, atau mendaftarkan diri sebagai jemaat baru. Pengunjung dapat melakukan konfirmasi donasi dengan mengisi data nama, telepon, jumlah, tujuan donasi, dan tanggal transfer. Selain itu, pengunjung dapat mengirim pesan melalui halaman kontak dengan menyertakan nama, email, subjek, dan isi pesan. |

---

### b. Admin

| Komponen | Keterangan |
|----------|------------|
| **Actor** | Admin |
| **Brief Description** | Admin adalah pengguna dengan hak akses penuh yang bertugas mengelola seluruh konten dan data sistem informasi gereja, termasuk jadwal, kegiatan, keuangan, formulir, pengguna, dan profil gereja. |
| **Main Flow** | Admin melakukan login ke sistem menggunakan kredensial yang valid. Setelah berhasil login, admin dapat mengakses dashboard untuk melihat ringkasan data. Admin dapat mengelola jadwal ibadah mingguan dan ibadah khusus dengan menambah, mengubah, atau menghapus jadwal. Admin dapat mengelola OIG (Organisasi Intra Gereja) termasuk informasi pengurus dan jadwal kegiatan. Admin dapat mengelola kegiatan gereja baik rutin maupun khusus dengan dokumentasi foto. Admin dapat mengelola berita dan pengumuman gereja dengan fitur draft/publish. Admin dapat mengelola kalender acara gereja. Admin dapat melihat dan memproses formulir yang masuk (doa, pendaftaran, konseling) serta memberikan catatan dan mengubah status. Admin dapat mengelola keuangan gereja (pemasukan dan pengeluaran) serta mengekspor laporan. Admin dapat mengelola konfirmasi donasi dan mengubah statusnya. Admin dapat mengelola komunikasi internal gereja. Admin dapat mengelola pengguna sistem dengan menambah, mengubah, menghapus, dan reset password. Admin dapat mengelola data jemaat termasuk status aktif/non-aktif. Admin dapat mengelola profil gereja termasuk informasi pendeta dan majelis. Admin dapat mengelola rekening bank untuk donasi. Admin dapat melihat dan membalas pesan kontak dari pengunjung website. |

---

### c. Pendeta

| Komponen | Keterangan |
|----------|------------|
| **Actor** | Pendeta |
| **Brief Description** | Pendeta adalah pengguna dengan akses terbatas yang berfokus pada pelayanan pastoral. Pendeta dapat melihat data jemaat, pesan kontak, serta mengelola formulir doa dan konseling. |
| **Main Flow** | Pendeta melakukan login ke sistem menggunakan kredensial yang valid. Setelah berhasil login, pendeta dapat mengakses dashboard khusus yang menampilkan ringkasan data pastoral. Pendeta dapat melihat daftar data jemaat dan detail informasi jemaat untuk keperluan pelayanan. Pendeta dapat melihat pesan kontak yang masuk dari pengunjung website. Pendeta memiliki akses penuh untuk mengelola formulir permohonan doa termasuk melihat detail permohonan, mengubah status (pending/proses/selesai), dan menambahkan catatan tindak lanjut. Pendeta juga memiliki akses penuh untuk mengelola formulir konseling termasuk melihat detail pengajuan, mengubah status (pending/dijadwalkan/selesai/batal), dan menambahkan catatan. |

---

## 2. Activity Diagram

### a. Activity Diagram - Pengunjung Mengisi Formulir Doa

```
    +-------------------+
    |      START        |
    +--------+----------+
             |
             v
    +-------------------+
    | Akses Halaman     |
    | Formulir          |
    +--------+----------+
             |
             v
    +-------------------+
    | Pilih Formulir    |
    | Doa               |
    +--------+----------+
             |
             v
    +-------------------+
    | Isi Data:         |
    | - Nama            |
    | - Telepon         |
    | - Email           |
    | - Kategori        |
    | - Permohonan      |
    | - Privasi         |
    +--------+----------+
             |
             v
    +-------------------+
    | Klik Submit       |
    +--------+----------+
             |
             v
    +=========+=========+
    //       \         \\
   //  Valid? \\        \\
  ++=====+======++       ||
  || Ya  ||  Tidak       ||
  ++==+====+++           ||
     |      |            ||
     v      +------------++
    +-------------------+
    | Simpan ke         |
    | Database          |
    +--------+----------+
             |
             v
    +-------------------+
    | Tampilkan Pesan   |
    | Sukses            |
    +--------+----------+
             |
             v
    +-------------------+
    |       END         |
    +-------------------+
```

### b. Activity Diagram - Admin Mengelola Jadwal Ibadah

```
    +-------------------+
    |      START        |
    +--------+----------+
             |
             v
    +-------------------+
    | Admin Login       |
    +--------+----------+
             |
             v
    +=========+=========+
    //       \         \\
   //  Valid? \\        \\
  ++=====+======++       ||
  || Ya  ||  Tidak       ||
  ++==+====+++           ||
     |      |            ||
     v      +------> [Kembali ke Login]
    +-------------------+
    | Akses Dashboard   |
    +--------+----------+
             |
             v
    +-------------------+
    | Pilih Menu        |
    | Jadwal Ibadah     |
    +--------+----------+
             |
             v
    +-------------------+
    | Lihat Daftar      |
    | Jadwal            |
    +--------+----------+
             |
             v
    +=========+=========+
    //  Pilih Aksi?    \\
   //                   \\
  ++====+==+====+========++
  |Tambah| |Edit| |Hapus |
  ++==+=++  ++==++  ++==++
     |       |       |
     v       v       v
  +------+ +------+ +------+
  | Form | | Form | |Konfir|
  | Baru | | Edit | | masi |
  +--+---+ +--+---+ +--+---+
     |       |          |
     v       v          v
  +------+ +------+ +------+
  |Simpan| |Update| |Delete|
  +--+---+ +--+---+ +--+---+
     |       |          |
     +-------+----------+
             |
             v
    +-------------------+
    | Tampilkan Notif   |
    | Sukses            |
    +--------+----------+
             |
             v
    +-------------------+
    |       END         |
    +-------------------+
```

### c. Activity Diagram - Pendeta Mengelola Formulir Konseling

```
    +-------------------+
    |      START        |
    +--------+----------+
             |
             v
    +-------------------+
    | Pendeta Login     |
    +--------+----------+
             |
             v
    +-------------------+
    | Akses Dashboard   |
    | Pendeta           |
    +--------+----------+
             |
             v
    +-------------------+
    | Pilih Menu        |
    | Formulir          |
    +--------+----------+
             |
             v
    +-------------------+
    | Pilih Tab         |
    | Konseling         |
    +--------+----------+
             |
             v
    +-------------------+
    | Lihat Daftar      |
    | Pengajuan         |
    +--------+----------+
             |
             v
    +-------------------+
    | Pilih Pengajuan   |
    +--------+----------+
             |
             v
    +=========+=========+
    //  Pilih Aksi?    \\
   //                   \\
  ++====+========+======++
  |Ubah Status |Catatan|
  ++==+======++  ++=+==++
     |            |
     v            v
  +----------+ +----------+
  |Pending   | |Tambah/   |
  |Dijadwal  | |Edit      |
  |Selesai   | |Catatan   |
  |Batal     | +----+-----+
  +----+-----+      |
       |            |
       +------------+
             |
             v
    +-------------------+
    | Simpan Perubahan  |
    +--------+----------+
             |
             v
    +-------------------+
    |       END         |
    +-------------------+
```

---

## 3. Sequence Diagram

### a. Sequence Diagram - Pengunjung Mengisi Formulir Doa

```
+------------+     +------------+     +------------------+     +-------------+
| Pengunjung |     |   View     |     |   Controller     |     |  Database   |
+-----+------+     +-----+------+     +--------+---------+     +------+------+
      |                  |                     |                      |
      | Akses /formulir/doa                    |                      |
      |----------------->|                     |                      |
      |                  | Request doa form    |                      |
      |                  |-------------------->|                      |
      |                  |                     |                      |
      |                  | Return doa form view|                      |
      |                  |<--------------------|                      |
      |  Tampilkan Form  |                     |                      |
      |<-----------------|                     |                      |
      |                  |                     |                      |
      | Isi & Submit Form|                     |                      |
      |----------------->|                     |                      |
      |                  | POST data formulir  |                      |
      |                  |-------------------->|                      |
      |                  |                     | Validate data        |
      |                  |                     |---------+            |
      |                  |                     |<--------+            |
      |                  |                     |                      |
      |                  |                     | Generate kode        |
      |                  |                     |---------+            |
      |                  |                     |<--------+            |
      |                  |                     |                      |
      |                  |                     | INSERT formulir_doa  |
      |                  |                     |--------------------->|
      |                  |                     |                      |
      |                  |                     |      Success         |
      |                  |                     |<---------------------|
      |                  |                     |                      |
      |                  | Return success msg  |                      |
      |                  |<--------------------|                      |
      | Tampilkan Notif  |                     |                      |
      |<-----------------|                     |                      |
      |                  |                     |                      |
```

### b. Sequence Diagram - Admin Mengelola Jadwal Ibadah

```
+-------+     +------------+     +-----------------+     +-------------+
| Admin |     |   View     |     |   Controller    |     |  Database   |
+---+---+     +-----+------+     +--------+--------+     +------+------+
    |               |                     |                     |
    | Akses /admin/jadwal                 |                     |
    |-------------->|                     |                     |
    |               | Request jadwal list |                     |
    |               |-------------------->|                     |
    |               |                     | SELECT jadwal_ibadah|
    |               |                     |-------------------->|
    |               |                     |                     |
    |               |                     |   Return data       |
    |               |                     |<--------------------|
    |               | Return jadwal view  |                     |
    |               |<--------------------|                     |
    | Tampilkan List|                     |                     |
    |<--------------|                     |                     |
    |               |                     |                     |
    | Klik Tambah   |                     |                     |
    |-------------->|                     |                     |
    |               | Request create form |                     |
    |               |-------------------->|                     |
    |               | Return form view    |                     |
    |               |<--------------------|                     |
    | Tampilkan Form|                     |                     |
    |<--------------|                     |                     |
    |               |                     |                     |
    | Submit Form   |                     |                     |
    |-------------->|                     |                     |
    |               | POST jadwal data    |                     |
    |               |-------------------->|                     |
    |               |                     | Validate data       |
    |               |                     |--------+            |
    |               |                     |<-------+            |
    |               |                     |                     |
    |               |                     | INSERT jadwal_ibadah|
    |               |                     |-------------------->|
    |               |                     |                     |
    |               |                     |      Success        |
    |               |                     |<--------------------|
    |               |                     |                     |
    |               | Redirect + notif    |                     |
    |               |<--------------------|                     |
    | Tampilkan List|                     |                     |
    |<--------------|                     |                     |
    |               |                     |                     |
```

### c. Sequence Diagram - Pendeta Melihat Data Jemaat

```
+---------+     +------------+     +-----------------+     +-------------+
| Pendeta |     |   View     |     |   Controller    |     |  Database   |
+----+----+     +-----+------+     +--------+--------+     +------+------+
     |                |                     |                     |
     | Akses /pendeta/jemaat                |                     |
     |--------------->|                     |                     |
     |                | Request jemaat index|                     |
     |                |-------------------->|                     |
     |                |                     | SELECT jemaat       |
     |                |                     |-------------------->|
     |                |                     |                     |
     |                |                     |   Return data       |
     |                |                     |<--------------------|
     |                | Return jemaat view  |                     |
     |                |<--------------------|                     |
     | Tampilkan List |                     |                     |
     |<---------------|                     |                     |
     |                |                     |                     |
     | Klik Detail Jemaat                   |                     |
     |--------------->|                     |                     |
     |                | Request jemaat/{id} |                     |
     |                |-------------------->|                     |
     |                |                     | SELECT jemaat WHERE |
     |                |                     | id = {id}           |
     |                |                     |-------------------->|
     |                |                     |                     |
     |                |                     |   Return data       |
     |                |                     |<--------------------|
     |                | Return detail view  |                     |
     |                |<--------------------|                     |
     |Tampilkan Detail|                     |                     |
     |<---------------|                     |                     |
     |                |                     |                     |
```

---

## 4. Class Diagram

```
+=====================================================+
|                      «Model»                        |
|                       User                          |
+=====================================================+
| - id: bigint                                        |
| - name: string                                      |
| - email: string                                     |
| - email_verified_at: timestamp                      |
| - password: string                                  |
| - role: enum(admin,pendeta)                         |
| - remember_token: string                            |
| - created_at: timestamp                             |
| - updated_at: timestamp                             |
+-----------------------------------------------------+
| + berita(): HasMany                                 |
+=====================================================+
                         |
                         | 1
                         |
                         | *
+=====================================================+
|                      «Model»                        |
|                      Berita                         |
+=====================================================+
| - id: bigint                                        |
| - judul: string                                     |
| - slug: string                                      |
| - ringkasan: text                                   |
| - isi: longText                                     |
| - gambar: string                                    |
| - tanggal_publikasi: date                           |
| - status: enum(draft,published)                     |
| - aktif: boolean                                    |
| - author_id: bigint (FK -> users)                   |
| - created_at: timestamp                             |
| - updated_at: timestamp                             |
+-----------------------------------------------------+
| + author(): BelongsTo<User>                         |
| + scopePublished(): Builder                         |
| + scopeActive(): Builder                            |
+=====================================================+


+=====================================================+
|                      «Model»                        |
|                      Jemaat                         |
+=====================================================+
| - id: bigint                                        |
| - nama: string                                      |
| - telepon: string                                   |
| - email: string                                     |
| - alamat: text                                      |
| - tanggal_lahir: date                               |
| - jenis_kelamin: enum(L,P)                          |
| - status_pernikahan: string                         |
| - pekerjaan: string                                 |
| - aktif: boolean                                    |
| - created_at: timestamp                             |
| - updated_at: timestamp                             |
+-----------------------------------------------------+
| + scopeAktif(): Builder                             |
+=====================================================+


+=====================================================+
|                      «Model»                        |
|                   JadwalIbadah                      |
+=====================================================+
| - id: bigint                                        |
| - nama: string                                      |
| - hari: string                                      |
| - waktu: string                                     |
| - tempat: string                                    |
| - pelayan: string                                   |
| - online: boolean                                   |
| - tipe: enum(mingguan,khusus)                       |
| - kategori: string                                  |
| - tanggal: date                                     |
| - aktif: boolean                                    |
| - created_at: timestamp                             |
| - updated_at: timestamp                             |
+-----------------------------------------------------+
| + scopeMingguan(): Builder                          |
| + scopeKhusus(): Builder                            |
| + scopeAktif(): Builder                             |
+=====================================================+


+=====================================================+
|                      «Model»                        |
|                     Kegiatan                        |
+=====================================================+
| - id: bigint                                        |
| - nama: string                                      |
| - slug: string                                      |
| - deskripsi: text                                   |
| - jadwal: string                                    |
| - waktu: string                                     |
| - tempat: string                                    |
| - tipe: enum(rutin,khusus)                          |
| - kategori: string                                  |
| - tanggal: date                                     |
| - dokumentasi: json                                 |
| - aktif: boolean                                    |
| - created_at: timestamp                             |
| - updated_at: timestamp                             |
+-----------------------------------------------------+
| + pendaftaran(): HasMany<FormulirPendaftaran>       |
| + scopeRutin(): Builder                             |
| + scopeKhusus(): Builder                            |
| + scopeAktif(): Builder                             |
+=====================================================+
                         |
                         | 1
                         |
                         | *
+=====================================================+
|                      «Model»                        |
|               FormulirPendaftaran                   |
+=====================================================+
| - id: bigint                                        |
| - kode: string                                      |
| - nama: string                                      |
| - telepon: string                                   |
| - email: string                                     |
| - usia: integer                                     |
| - kegiatan_id: bigint (FK -> kegiatan)              |
| - nama_kegiatan: string                             |
| - catatan: text                                     |
| - status: enum(pending,konfirmasi,hadir,batal)      |
| - created_at: timestamp                             |
| - updated_at: timestamp                             |
+-----------------------------------------------------+
| + kegiatan(): BelongsTo<Kegiatan>                   |
| + notes(): HasMany<FormulirNote>                    |
+=====================================================+


+=====================================================+
|                      «Model»                        |
|                   FormulirDoa                       |
+=====================================================+
| - id: bigint                                        |
| - kode: string                                      |
| - nama: string                                      |
| - telepon: string                                   |
| - email: string                                     |
| - kategori: string                                  |
| - permohonan: text                                  |
| - privasi: boolean                                  |
| - status: enum(pending,proses,selesai)              |
| - created_at: timestamp                             |
| - updated_at: timestamp                             |
+-----------------------------------------------------+
| + notes(): HasMany<FormulirNote>                    |
+=====================================================+


+=====================================================+
|                      «Model»                        |
|                FormulirKonseling                    |
+=====================================================+
| - id: bigint                                        |
| - kode: string                                      |
| - nama: string                                      |
| - telepon: string                                   |
| - jenis_kelamin: enum(laki-laki,perempuan)          |
| - kategori: string                                  |
| - metode: enum(tatap_muka,online,telepon)           |
| - waktu_diinginkan: datetime                        |
| - gambaran: text                                    |
| - status: enum(pending,dijadwalkan,selesai,batal)   |
| - created_at: timestamp                             |
| - updated_at: timestamp                             |
+-----------------------------------------------------+
| + notes(): HasMany<FormulirNote>                    |
+=====================================================+


+=====================================================+
|                      «Model»                        |
|                   FormulirNote                      |
+=====================================================+
| - id: bigint                                        |
| - formulir_type: string                             |
| - formulir_id: bigint                               |
| - catatan: text                                     |
| - created_at: timestamp                             |
| - updated_at: timestamp                             |
+-----------------------------------------------------+
| + formulirable(): MorphTo                           |
+=====================================================+


+=====================================================+
|                      «Model»                        |
|                     Keuangan                        |
+=====================================================+
| - id: bigint                                        |
| - tipe: enum(pemasukan,pengeluaran)                 |
| - keterangan: string                                |
| - jumlah: decimal(15,2)                             |
| - tanggal: date                                     |
| - periode: string                                   |
| - kategori: string                                  |
| - created_at: timestamp                             |
| - updated_at: timestamp                             |
+-----------------------------------------------------+
| + scopePemasukan(): Builder                         |
| + scopePengeluaran(): Builder                       |
+=====================================================+


+=====================================================+
|                      «Model»                        |
|                      Donasi                         |
+=====================================================+
| - id: bigint                                        |
| - nama: string                                      |
| - telepon: string                                   |
| - jumlah: decimal(15,2)                             |
| - tujuan: enum(persembahan,diakonia,pembangunan)    |
| - tanggal_transfer: date                            |
| - status: enum(pending,dikonfirmasi,ditolak)        |
| - created_at: timestamp                             |
| - updated_at: timestamp                             |
+=====================================================+


+=====================================================+
|                      «Model»                        |
|                        Oig                          |
+=====================================================+
| - id: bigint                                        |
| - nama: string                                      |
| - slug: string                                      |
| - deskripsi: text                                   |
| - ketua: string                                     |
| - jadwal: string                                    |
| - pengurus: json                                    |
| - created_at: timestamp                             |
| - updated_at: timestamp                             |
+=====================================================+


+=====================================================+
|                      «Model»                        |
|                   ProfilGereja                      |
+=====================================================+
| - id: bigint                                        |
| - nama_gereja: string                               |
| - alamat: text                                      |
| - telepon: string                                   |
| - email: string                                     |
| - tahun_berdiri: year                               |
| - visi: text                                        |
| - misi: json                                        |
| - created_at: timestamp                             |
| - updated_at: timestamp                             |
+=====================================================+


+=====================================================+
|                      «Model»                        |
|                     Pendeta                         |
+=====================================================+
| - id: bigint                                        |
| - nama: string                                      |
| - jabatan: string                                   |
| - telepon: string                                   |
| - email: string                                     |
| - mulai_melayani: string                            |
| - foto: string                                      |
| - created_at: timestamp                             |
| - updated_at: timestamp                             |
+=====================================================+


+=====================================================+
|                      «Model»                        |
|                     Majelis                         |
+=====================================================+
| - id: bigint                                        |
| - nama: string                                      |
| - jabatan: string                                   |
| - bidang: string                                    |
| - foto: string                                      |
| - urutan: integer                                   |
| - created_at: timestamp                             |
| - updated_at: timestamp                             |
+=====================================================+


+=====================================================+
|                      «Model»                        |
|                   Pengumuman                        |
+=====================================================+
| - id: bigint                                        |
| - judul: string                                     |
| - deskripsi: text                                   |
| - tanggal: date                                     |
| - aktif: boolean                                    |
| - created_at: timestamp                             |
| - updated_at: timestamp                             |
+=====================================================+


+=====================================================+
|                      «Model»                        |
|                    Kalender                         |
+=====================================================+
| - id: bigint                                        |
| - nama: string                                      |
| - tanggal: date                                     |
| - waktu: time                                       |
| - tipe: string                                      |
| - deskripsi: text                                   |
| - tempat: string                                    |
| - aktif: boolean                                    |
| - created_at: timestamp                             |
| - updated_at: timestamp                             |
+=====================================================+


+=====================================================+
|                      «Model»                        |
|                   Komunikasi                        |
+=====================================================+
| - id: bigint                                        |
| - judul: string                                     |
| - isi: text                                         |
| - tipe: string                                      |
| - created_at: timestamp                             |
| - updated_at: timestamp                             |
+=====================================================+


+=====================================================+
|                      «Model»                        |
|                  PesanKontak                        |
+=====================================================+
| - id: bigint                                        |
| - nama: string                                      |
| - email: string                                     |
| - subjek: string                                    |
| - pesan: text                                       |
| - dibaca: boolean                                   |
| - dibaca_at: timestamp                              |
| - created_at: timestamp                             |
| - updated_at: timestamp                             |
+=====================================================+


+=====================================================+
|                      «Model»                        |
|                  RekeningBank                       |
+=====================================================+
| - id: bigint                                        |
| - nama_bank: string                                 |
| - nomor_rekening: string                            |
| - atas_nama: string                                 |
| - kode_bank: string                                 |
| - is_primary: boolean                               |
| - aktif: boolean                                    |
| - urutan: integer                                   |
| - created_at: timestamp                             |
| - updated_at: timestamp                             |
+=====================================================+
```

---

## 5. Struktur Tabel Database

### a. Tabel users

```
+----------------------+------------------------+------+-----+---------+----------------+
| Field                | Type                   | Null | Key | Default | Extra          |
+----------------------+------------------------+------+-----+---------+----------------+
| id                   | bigint unsigned        | NO   | PRI | NULL    | auto_increment |
| name                 | varchar(255)           | NO   |     | NULL    |                |
| email                | varchar(255)           | NO   | UNI | NULL    |                |
| email_verified_at    | timestamp              | YES  |     | NULL    |                |
| password             | varchar(255)           | NO   |     | NULL    |                |
| role                 | enum('admin','pendeta')| YES  |     | admin   |                |
| remember_token       | varchar(100)           | YES  |     | NULL    |                |
| created_at           | timestamp              | YES  |     | NULL    |                |
| updated_at           | timestamp              | YES  |     | NULL    |                |
+----------------------+------------------------+------+-----+---------+----------------+
```

### b. Tabel jemaat

```
+------------------+---------------------+------+-----+---------+----------------+
| Field            | Type                | Null | Key | Default | Extra          |
+------------------+---------------------+------+-----+---------+----------------+
| id               | bigint unsigned     | NO   | PRI | NULL    | auto_increment |
| nama             | varchar(255)        | NO   |     | NULL    |                |
| telepon          | varchar(255)        | YES  |     | NULL    |                |
| email            | varchar(255)        | YES  |     | NULL    |                |
| alamat           | text                | YES  |     | NULL    |                |
| tanggal_lahir    | date                | YES  |     | NULL    |                |
| jenis_kelamin    | enum('L','P')       | YES  |     | NULL    |                |
| status_pernikahan| varchar(255)        | YES  |     | NULL    |                |
| pekerjaan        | varchar(255)        | YES  |     | NULL    |                |
| aktif            | tinyint(1)          | NO   |     | 1       |                |
| created_at       | timestamp           | YES  |     | NULL    |                |
| updated_at       | timestamp           | YES  |     | NULL    |                |
+------------------+---------------------+------+-----+---------+----------------+
```

### c. Tabel jadwal_ibadah

```
+------------------+------------------------------+------+-----+---------+----------------+
| Field            | Type                         | Null | Key | Default | Extra          |
+------------------+------------------------------+------+-----+---------+----------------+
| id               | bigint unsigned              | NO   | PRI | NULL    | auto_increment |
| nama             | varchar(255)                 | NO   |     | NULL    |                |
| hari             | varchar(255)                 | NO   |     | NULL    |                |
| waktu            | varchar(10)                  | NO   |     | NULL    |                |
| tempat           | varchar(255)                 | NO   |     | NULL    |                |
| pelayan          | varchar(255)                 | YES  |     | NULL    |                |
| online           | tinyint(1)                   | NO   |     | 0       |                |
| tipe             | enum('mingguan','khusus')    | NO   |     | mingguan|                |
| kategori         | varchar(255)                 | YES  |     | NULL    |                |
| tanggal          | date                         | YES  |     | NULL    |                |
| aktif            | tinyint(1)                   | NO   |     | 1       |                |
| created_at       | timestamp                    | YES  |     | NULL    |                |
| updated_at       | timestamp                    | YES  |     | NULL    |                |
+------------------+------------------------------+------+-----+---------+----------------+
```

### d. Tabel kegiatan

```
+------------------+--------------------------+------+-----+---------+----------------+
| Field            | Type                     | Null | Key | Default | Extra          |
+------------------+--------------------------+------+-----+---------+----------------+
| id               | bigint unsigned          | NO   | PRI | NULL    | auto_increment |
| nama             | varchar(255)             | NO   |     | NULL    |                |
| slug             | varchar(255)             | NO   | UNI | NULL    |                |
| deskripsi        | text                     | YES  |     | NULL    |                |
| jadwal           | varchar(255)             | YES  |     | NULL    |                |
| waktu            | varchar(20)              | YES  |     | NULL    |                |
| tempat           | varchar(255)             | YES  |     | NULL    |                |
| tipe             | enum('rutin','khusus')   | NO   |     | rutin   |                |
| kategori         | varchar(255)             | YES  |     | NULL    |                |
| tanggal          | date                     | YES  |     | NULL    |                |
| dokumentasi      | json                     | YES  |     | NULL    |                |
| aktif            | tinyint(1)               | NO   |     | 1       |                |
| created_at       | timestamp                | YES  |     | NULL    |                |
| updated_at       | timestamp                | YES  |     | NULL    |                |
+------------------+--------------------------+------+-----+---------+----------------+
```

### e. Tabel keuangan

```
+------------------+--------------------------------+------+-----+---------+----------------+
| Field            | Type                           | Null | Key | Default | Extra          |
+------------------+--------------------------------+------+-----+---------+----------------+
| id               | bigint unsigned                | NO   | PRI | NULL    | auto_increment |
| tipe             | enum('pemasukan','pengeluaran')| NO   |     | NULL    |                |
| keterangan       | varchar(255)                   | NO   |     | NULL    |                |
| jumlah           | decimal(15,2)                  | NO   |     | NULL    |                |
| tanggal          | date                           | NO   |     | NULL    |                |
| periode          | varchar(20)                    | YES  |     | NULL    |                |
| kategori         | varchar(255)                   | YES  |     | NULL    |                |
| created_at       | timestamp                      | YES  |     | NULL    |                |
| updated_at       | timestamp                      | YES  |     | NULL    |                |
+------------------+--------------------------------+------+-----+---------+----------------+
```

### f. Tabel donasi

```
+------------------+---------------------------------------------+------+-----+---------+----------------+
| Field            | Type                                        | Null | Key | Default | Extra          |
+------------------+---------------------------------------------+------+-----+---------+----------------+
| id               | bigint unsigned                             | NO   | PRI | NULL    | auto_increment |
| nama             | varchar(255)                                | NO   |     | NULL    |                |
| telepon          | varchar(20)                                 | NO   |     | NULL    |                |
| jumlah           | decimal(15,2)                               | NO   |     | NULL    |                |
| tujuan           | enum('persembahan','diakonia','pembangunan')| NO   |     | NULL    |                |
| tanggal_transfer | date                                        | NO   |     | NULL    |                |
| status           | enum('pending','dikonfirmasi','ditolak')    | NO   |     | pending |                |
| created_at       | timestamp                                   | YES  |     | NULL    |                |
| updated_at       | timestamp                                   | YES  |     | NULL    |                |
+------------------+---------------------------------------------+------+-----+---------+----------------+
```

### g. Tabel formulir_doa

```
+------------------+-----------------------------------+------+-----+---------+----------------+
| Field            | Type                              | Null | Key | Default | Extra          |
+------------------+-----------------------------------+------+-----+---------+----------------+
| id               | bigint unsigned                   | NO   | PRI | NULL    | auto_increment |
| kode             | varchar(255)                      | NO   | UNI | NULL    |                |
| nama             | varchar(255)                      | NO   |     | NULL    |                |
| telepon          | varchar(20)                       | NO   |     | NULL    |                |
| email            | varchar(255)                      | YES  |     | NULL    |                |
| kategori         | varchar(255)                      | NO   |     | NULL    |                |
| permohonan       | text                              | NO   |     | NULL    |                |
| privasi          | tinyint(1)                        | NO   |     | 0       |                |
| status           | enum('pending','proses','selesai')| NO   |     | pending |                |
| created_at       | timestamp                         | YES  |     | NULL    |                |
| updated_at       | timestamp                         | YES  |     | NULL    |                |
+------------------+-----------------------------------+------+-----+---------+----------------+
```

### h. Tabel formulir_pendaftaran

```
+------------------+----------------------------------------------+------+-----+---------+----------------+
| Field            | Type                                         | Null | Key | Default | Extra          |
+------------------+----------------------------------------------+------+-----+---------+----------------+
| id               | bigint unsigned                              | NO   | PRI | NULL    | auto_increment |
| kode             | varchar(255)                                 | NO   | UNI | NULL    |                |
| nama             | varchar(255)                                 | NO   |     | NULL    |                |
| telepon          | varchar(20)                                  | NO   |     | NULL    |                |
| email            | varchar(255)                                 | YES  |     | NULL    |                |
| usia             | int                                          | YES  |     | NULL    |                |
| kegiatan_id      | bigint unsigned                              | YES  | MUL | NULL    |                |
| nama_kegiatan    | varchar(255)                                 | YES  |     | NULL    |                |
| catatan          | text                                         | YES  |     | NULL    |                |
| status           | enum('pending','konfirmasi','hadir','batal') | NO   |     | pending |                |
| created_at       | timestamp                                    | YES  |     | NULL    |                |
| updated_at       | timestamp                                    | YES  |     | NULL    |                |
+------------------+----------------------------------------------+------+-----+---------+----------------+
```

### i. Tabel formulir_konseling

```
+------------------+------------------------------------------------+------+-----+---------+----------------+
| Field            | Type                                           | Null | Key | Default | Extra          |
+------------------+------------------------------------------------+------+-----+---------+----------------+
| id               | bigint unsigned                                | NO   | PRI | NULL    | auto_increment |
| kode             | varchar(255)                                   | NO   | UNI | NULL    |                |
| nama             | varchar(255)                                   | NO   |     | NULL    |                |
| telepon          | varchar(20)                                    | NO   |     | NULL    |                |
| jenis_kelamin    | enum('laki-laki','perempuan')                  | YES  |     | NULL    |                |
| kategori         | varchar(255)                                   | NO   |     | NULL    |                |
| metode           | enum('tatap_muka','online','telepon')          | YES  |     | NULL    |                |
| waktu_diinginkan | datetime                                       | YES  |     | NULL    |                |
| gambaran         | text                                           | NO   |     | NULL    |                |
| status           | enum('pending','dijadwalkan','selesai','batal')| NO   |     | pending |                |
| created_at       | timestamp                                      | YES  |     | NULL    |                |
| updated_at       | timestamp                                      | YES  |     | NULL    |                |
+------------------+------------------------------------------------+------+-----+---------+----------------+
```

### j. Tabel berita

```
+--------------------+---------------------------+------+-----+---------+----------------+
| Field              | Type                      | Null | Key | Default | Extra          |
+--------------------+---------------------------+------+-----+---------+----------------+
| id                 | bigint unsigned           | NO   | PRI | NULL    | auto_increment |
| judul              | varchar(255)              | NO   |     | NULL    |                |
| slug               | varchar(255)              | NO   | UNI | NULL    |                |
| ringkasan          | text                      | YES  |     | NULL    |                |
| isi                | longtext                  | NO   |     | NULL    |                |
| gambar             | varchar(255)              | YES  |     | NULL    |                |
| tanggal_publikasi  | date                      | NO   |     | NULL    |                |
| status             | enum('draft','published') | NO   |     | draft   |                |
| aktif              | tinyint(1)                | NO   |     | 1       |                |
| author_id          | bigint unsigned           | YES  | MUL | NULL    |                |
| created_at         | timestamp                 | YES  |     | NULL    |                |
| updated_at         | timestamp                 | YES  |     | NULL    |                |
+--------------------+---------------------------+------+-----+---------+----------------+
```

### k. Tabel pengumuman

```
+------------------+---------------------+------+-----+---------+----------------+
| Field            | Type                | Null | Key | Default | Extra          |
+------------------+---------------------+------+-----+---------+----------------+
| id               | bigint unsigned     | NO   | PRI | NULL    | auto_increment |
| judul            | varchar(255)        | NO   |     | NULL    |                |
| deskripsi        | text                | NO   |     | NULL    |                |
| tanggal          | date                | NO   |     | NULL    |                |
| aktif            | tinyint(1)          | NO   |     | 1       |                |
| created_at       | timestamp           | YES  |     | NULL    |                |
| updated_at       | timestamp           | YES  |     | NULL    |                |
+------------------+---------------------+------+-----+---------+----------------+
```

### l. Tabel oig

```
+------------------+---------------------+------+-----+---------+----------------+
| Field            | Type                | Null | Key | Default | Extra          |
+------------------+---------------------+------+-----+---------+----------------+
| id               | bigint unsigned     | NO   | PRI | NULL    | auto_increment |
| nama             | varchar(255)        | NO   |     | NULL    |                |
| slug             | varchar(255)        | NO   | UNI | NULL    |                |
| deskripsi        | text                | YES  |     | NULL    |                |
| ketua            | varchar(255)        | YES  |     | NULL    |                |
| jadwal           | varchar(255)        | YES  |     | NULL    |                |
| pengurus         | json                | YES  |     | NULL    |                |
| created_at       | timestamp           | YES  |     | NULL    |                |
| updated_at       | timestamp           | YES  |     | NULL    |                |
+------------------+---------------------+------+-----+---------+----------------+
```

### m. Tabel profil_gereja

```
+------------------+---------------------+------+-----+---------+----------------+
| Field            | Type                | Null | Key | Default | Extra          |
+------------------+---------------------+------+-----+---------+----------------+
| id               | bigint unsigned     | NO   | PRI | NULL    | auto_increment |
| nama_gereja      | varchar(255)        | NO   |     | NULL    |                |
| alamat           | text                | NO   |     | NULL    |                |
| telepon          | varchar(20)         | YES  |     | NULL    |                |
| email            | varchar(255)        | YES  |     | NULL    |                |
| tahun_berdiri    | year                | YES  |     | NULL    |                |
| visi             | text                | YES  |     | NULL    |                |
| misi             | json                | YES  |     | NULL    |                |
| created_at       | timestamp           | YES  |     | NULL    |                |
| updated_at       | timestamp           | YES  |     | NULL    |                |
+------------------+---------------------+------+-----+---------+----------------+
```

### n. Tabel pendeta

```
+------------------+---------------------+------+-----+---------------+----------------+
| Field            | Type                | Null | Key | Default       | Extra          |
+------------------+---------------------+------+-----+---------------+----------------+
| id               | bigint unsigned     | NO   | PRI | NULL          | auto_increment |
| nama             | varchar(255)        | NO   |     | NULL          |                |
| jabatan          | varchar(255)        | NO   |     | Pendeta Jemaat|                |
| telepon          | varchar(20)         | YES  |     | NULL          |                |
| email            | varchar(255)        | YES  |     | NULL          |                |
| mulai_melayani   | varchar(10)         | YES  |     | NULL          |                |
| foto             | varchar(255)        | YES  |     | NULL          |                |
| created_at       | timestamp           | YES  |     | NULL          |                |
| updated_at       | timestamp           | YES  |     | NULL          |                |
+------------------+---------------------+------+-----+---------------+----------------+
```

### o. Tabel majelis

```
+------------------+---------------------+------+-----+---------+----------------+
| Field            | Type                | Null | Key | Default | Extra          |
+------------------+---------------------+------+-----+---------+----------------+
| id               | bigint unsigned     | NO   | PRI | NULL    | auto_increment |
| nama             | varchar(255)        | NO   |     | NULL    |                |
| jabatan          | varchar(255)        | NO   |     | NULL    |                |
| bidang           | varchar(255)        | NO   |     | NULL    |                |
| foto             | varchar(255)        | YES  |     | NULL    |                |
| urutan           | int                 | NO   |     | 0       |                |
| created_at       | timestamp           | YES  |     | NULL    |                |
| updated_at       | timestamp           | YES  |     | NULL    |                |
+------------------+---------------------+------+-----+---------+----------------+
```

### p. Tabel kalender

```
+------------------+---------------------+------+-----+---------+----------------+
| Field            | Type                | Null | Key | Default | Extra          |
+------------------+---------------------+------+-----+---------+----------------+
| id               | bigint unsigned     | NO   | PRI | NULL    | auto_increment |
| nama             | varchar(255)        | NO   |     | NULL    |                |
| tanggal          | date                | NO   |     | NULL    |                |
| waktu            | time                | YES  |     | NULL    |                |
| tipe             | varchar(255)        | NO   |     | ibadah  |                |
| deskripsi        | text                | YES  |     | NULL    |                |
| tempat           | varchar(255)        | YES  |     | NULL    |                |
| aktif            | tinyint(1)          | NO   |     | 1       |                |
| created_at       | timestamp           | YES  |     | NULL    |                |
| updated_at       | timestamp           | YES  |     | NULL    |                |
+------------------+---------------------+------+-----+---------+----------------+
```

### q. Tabel pesan_kontak

```
+------------------+---------------------+------+-----+---------+----------------+
| Field            | Type                | Null | Key | Default | Extra          |
+------------------+---------------------+------+-----+---------+----------------+
| id               | bigint unsigned     | NO   | PRI | NULL    | auto_increment |
| nama             | varchar(255)        | NO   |     | NULL    |                |
| email            | varchar(255)        | NO   |     | NULL    |                |
| subjek           | varchar(255)        | NO   |     | NULL    |                |
| pesan            | text                | NO   |     | NULL    |                |
| dibaca           | tinyint(1)          | NO   |     | 0       |                |
| dibaca_at        | timestamp           | YES  |     | NULL    |                |
| created_at       | timestamp           | YES  |     | NULL    |                |
| updated_at       | timestamp           | YES  |     | NULL    |                |
+------------------+---------------------+------+-----+---------+----------------+
```

### r. Tabel rekening_bank

```
+------------------+---------------------+------+-----+---------+----------------+
| Field            | Type                | Null | Key | Default | Extra          |
+------------------+---------------------+------+-----+---------+----------------+
| id               | bigint unsigned     | NO   | PRI | NULL    | auto_increment |
| nama_bank        | varchar(255)        | NO   |     | NULL    |                |
| nomor_rekening   | varchar(255)        | NO   |     | NULL    |                |
| atas_nama        | varchar(255)        | NO   |     | NULL    |                |
| kode_bank        | varchar(255)        | YES  |     | NULL    |                |
| is_primary       | tinyint(1)          | NO   |     | 0       |                |
| aktif            | tinyint(1)          | NO   |     | 1       |                |
| urutan           | int                 | NO   |     | 0       |                |
| created_at       | timestamp           | YES  |     | NULL    |                |
| updated_at       | timestamp           | YES  |     | NULL    |                |
+------------------+---------------------+------+-----+---------+----------------+
```

---

## Relasi Antar Tabel

```
+-------------------+          +--------------------+
|      users        |          |       berita       |
+-------------------+          +--------------------+
| PK: id            |<-------->| FK: author_id      |
+-------------------+    1:N   +--------------------+

+-------------------+          +--------------------+
|     kegiatan      |          |formulir_pendaftaran|
+-------------------+          +--------------------+
| PK: id            |<-------->| FK: kegiatan_id    |
+-------------------+    1:N   +--------------------+

+-------------------+          +--------------------+
|  formulir_doa     |          |   formulir_notes   |
+-------------------+          +--------------------+
| PK: id            |<-------->| FK: formulir_id    |
+-------------------+    1:N   | formulir_type='doa'|
                               +--------------------+

+-------------------+          +--------------------+
|formulir_konseling |          |   formulir_notes   |
+-------------------+          +--------------------+
| PK: id            |<-------->| FK: formulir_id    |
+-------------------+    1:N   | formulir_type=     |
                               | 'konseling'        |
                               +--------------------+

+-------------------+          +--------------------+
|formulir_pendaftaran|         |   formulir_notes   |
+-------------------+          +--------------------+
| PK: id            |<-------->| FK: formulir_id    |
+-------------------+    1:N   | formulir_type=     |
                               | 'pendaftaran'      |
                               +--------------------+
```

---

**Dokumen ini dibuat secara otomatis berdasarkan analisis kode sumber Sistem Informasi Gereja Buntu Ambaang.**
