# Sequence Diagram (PlantUML)

Berikut adalah representasi Sequence Diagram untuk proses-proses dalam sistem, berdasarkan Activity Diagram yang telah dibuat.

## 1. Pengunjung Mengisi Formulir Doa

```plantuml
@startuml
!theme plain
title Pengunjung Mengisi Formulir Doa
actor Pengunjung
boundary "Halaman Formulir" as View
control "FormulirController" as Controller
entity "FormulirDoa" as Model
database "Database" as DB

activate Pengunjung
Pengunjung -> View : Akses Halaman Formulir
activate View
View --> Pengunjung : Tampilkan Form
deactivate View

loop Validasi Data
    Pengunjung -> View : Isi Data (Nama, Email, Permohonan, dll)
    Pengunjung -> View : Klik Submit
    activate View
    View -> Controller : submitForm(data)
    activate Controller
    Controller -> Controller : validate(data)
    
    alt Data Tidak Valid
        Controller --> View : return validation errors
        View --> Pengunjung : Tampilkan Pesan Error
    else Data Valid
        Controller -> Model : new FormulirDoa(data)
        activate Model
        Model -> DB : save()
        activate DB
        DB --> Model : success
        deactivate DB
        Model --> Controller : saved
        deactivate Model
        
        Controller --> View : return success
        deactivate Controller
        View --> Pengunjung : Tampilkan Pesan Sukses
        deactivate View
    end
end
deactivate Pengunjung
@enduml
```

## 2. Admin Mengelola Jadwal Ibadah

```plantuml
@startuml
!theme plain
title Admin Mengelola Jadwal Ibadah
actor Admin
boundary "Dashboard View" as Dashboard
boundary "Jadwal View" as View
control "JadwalController" as Controller
entity "JadwalIbadah" as Model
database "Database" as DB

activate Admin
Admin -> Dashboard : Pilih Menu Jadwal Ibadah
activate Dashboard
Dashboard -> Controller : index()
activate Controller
Controller -> Model : all()
activate Model
Model -> DB : select * from jadwal
activate DB
DB --> Model : list_jadwal
deactivate DB
Model --> Controller : return list
deactivate Model
Controller --> View : loadView(list)
deactivate Controller
activate View
View --> Dashboard : display
deactivate Dashboard
View --> Admin : Tampilkan Daftar Jadwal

alt Tambah Jadwal
    Admin -> View : Klik Tambah
    View --> Admin : Tampilkan Form Tambah
    Admin -> View : Input Data
    Admin -> View : Klik Simpan
    activate View
    View -> Controller : store(data)
    activate Controller
    Controller -> Model : create(data)
    activate Model
    Model -> DB : insert()
    activate DB
    DB --> Model : success
    deactivate DB
    Model --> Controller : created
    deactivate Model
    Controller --> View : redirect/success
    deactivate Controller
    View --> Admin : Tampilkan Notif Sukses
    deactivate View

else Edit Jadwal
    Admin -> View : Pilih Jadwal & Klik Edit
    View -> Controller : edit(id)
    activate Controller
    Controller -> Model : find(id)
    activate Model
    Model -> DB : select where id
    activate DB
    DB --> Model : data
    deactivate DB
    Model --> Controller : data
    deactivate Model
    Controller --> View : loadFormEdit(data)
    deactivate Controller
    View --> Admin : Tampilkan Form Edit
    
    Admin -> View : Update Data & Klik Simpan
    activate View
    View -> Controller : update(id, data)
    activate Controller
    Controller -> Model : update(data)
    activate Model
    Model -> DB : update where id
    activate DB
    DB --> Model : success
    deactivate DB
    Model --> Controller : updated
    deactivate Model
    Controller --> View : redirect/success
    deactivate Controller
    View --> Admin : Tampilkan Notif Sukses
    deactivate View

else Hapus Jadwal
    Admin -> View : Pilih Jadwal & Klik Hapus
    View --> Admin : Konfirmasi Hapus?
    Admin -> View : Ya
    activate View
    View -> Controller : destroy(id)
    activate Controller
    Controller -> Model : delete(id)
    activate Model
    Model -> DB : delete where id
    activate DB
    DB --> Model : success
    deactivate DB
    Model --> Controller : deleted
    deactivate Model
    Controller --> View : refresh list
    deactivate Controller
    View --> Admin : Tampilkan Notif Sukses
    deactivate View
end
deactivate Admin
@enduml
```

## 3. Admin: Lihat Dashboard

```plantuml
@startuml
!theme plain
title Admin - Lihat Dashboard
actor Admin
boundary "Login Page" as Login
boundary "Dashboard View" as Dashboard
control "AuthController" as Auth
control "DashboardController" as Controller
entity "StatistikModel" as Stat
database "Database" as DB

activate Admin
Admin -> Login : Input Credential
activate Login
Login -> Auth : authenticate(user, pass)
activate Auth
Auth -> DB : check_credentials()
activate DB
DB --> Auth : valid/invalid
deactivate DB

alt Login Valid
    Auth --> Dashboard : redirect()
    deactivate Auth
    deactivate Login
    activate Dashboard
    Dashboard -> Controller : index()
    activate Controller
    
    Controller -> Stat : getJemaatCount()
    activate Stat
    Stat -> DB : count(jemaat)
    DB --> Stat : number
    Stat --> Controller : count
    deactivate Stat

    Controller -> Stat : getUpcomingJadwal()
    activate Stat
    Stat -> DB : select top 1 jadwal
    DB --> Stat : jadwal
    Stat --> Controller : jadwal
    deactivate Stat

    Controller -> Stat : getFinanceSummary()
    activate Stat
    Stat -> DB : sum(pemasukan) - sum(pengeluaran)
    DB --> Stat : total
    Stat --> Controller : total
    deactivate Stat
    
    Controller --> Dashboard : render(data)
    deactivate Controller
    Dashboard --> Admin : Tampilkan Dashboard
    deactivate Dashboard
else Login Invalid
    activate Login
    activate Auth
    Auth --> Login : return error
    deactivate Auth
    Login --> Admin : Tampilkan Pesan Error
    deactivate Login
end
deactivate Admin
@enduml
```

## 4. Admin: Kelola OIG & Kegiatan

```plantuml
@startuml
!theme plain
title Admin - Kelola OIG & Kegiatan
actor Admin
boundary "OIG/Kegiatan View" as View
control "OIGController" as Controller
entity "OIG_Kegiatan" as Model
database "Database" as DB

activate Admin
Admin -> View : Buka Menu OIG
activate View
View -> Controller : index()
activate Controller
Controller -> Model : all()
activate Model
Model -> DB : fetch()
DB --> Model : data
deactivate Model
Controller --> View : show list
deactivate Controller
View --> Admin : Tampilkan Daftar

alt Tambah
    Admin -> View : Klik Tambah
    View --> Admin : Form Input
    Admin -> View : Isi Data & Upload Foto
    Admin -> View : Submit
    activate View
    View -> Controller : store(data, file)
    activate Controller
    Controller -> Controller : uploadFile()
    Controller -> Model : create(data)
    activate Model
    Model -> DB : insert
    DB --> Model : success
    deactivate Model
    Controller --> View : success
    deactivate Controller
    View --> Admin : Notif Sukses
    deactivate View
else Edit
    Admin -> View : Klik Edit
    View -> Controller : edit(id)
    activate Controller
    Controller --> View : Form Edit (prefilled)
    deactivate Controller
    Admin -> View : Update Data
    Admin -> View : Submit
    activate View
    View -> Controller : update(id, data)
    activate Controller
    Controller -> Model : update()
    activate Model
    Model -> DB : update
    DB --> Model : success
    deactivate Model
    Controller --> View : success
    deactivate Controller
    View --> Admin : Notif Sukses
    deactivate View
else Hapus
    Admin -> View : Klik Hapus
    View -> Controller : destroy(id)
    activate Controller
    Controller -> Model : delete()
    activate Model
    Model -> DB : delete
    DB --> Model : success
    deactivate Model
    Controller --> View : success
    deactivate Controller
    View --> Admin : Notif Sukses
end
deactivate Admin
@enduml
```

## 5. Admin: Kelola Berita & Pengumuman

```plantuml
@startuml
!theme plain
title Admin - Kelola Berita & Pengumuman
actor Admin
boundary "Berita View" as View
control "BeritaController" as Controller
entity "Berita" as Model
database "Database" as DB

activate Admin
Admin -> View : Akses Halaman Berita
View -> Controller : index()
Controller -> Model : getLatest()
Model -> DB : select
DB --> Model : data
Model --> Controller : data
Controller --> View : render list
View --> Admin : Tampilkan Berita

alt Tambah Berita
    Admin -> View : Klik Tambah
    View --> Admin : Show Form
    Admin -> View : Input Judul, Konten
    Admin -> View : Pilih Status (Draft/Publish)
    Admin -> View : Simpan
    activate View
    View -> Controller : store(data)
    activate Controller
    Controller -> Model : create(data)
    activate Model
    Model -> DB : insert
    DB --> Model : ok
    deactivate Model
    Controller --> View : success
    deactivate Controller
    View --> Admin : Berita Tersimpan
    deactivate View
else Edit Berita
    Admin -> View : Pilih Berita -> Edit
    View -> Controller : edit(id)
    Controller --> View : form(data)
    Admin -> View : Ubah Konten
    Admin -> View : Simpan
    activate View
    View -> Controller : update(id, data)
    activate Controller
    Controller -> Model : update()
    activate Model
    Model -> DB : update
    deactivate Model
    Controller --> View : success
    deactivate Controller
    View --> Admin : Perubahan Disimpan
    deactivate View
end
deactivate Admin
@enduml
```

## 6. Admin: Kelola Data Jemaat

```plantuml
@startuml
!theme plain
title Admin - Kelola Data Jemaat
actor Admin
boundary "Jemaat View" as View
control "JemaatController" as Controller
entity "Jemaat" as Model
database "Database" as DB

activate Admin
Admin -> View : Buka Menu Jemaat
View -> Controller : index()
Controller -> Model : paginate()
Model -> DB : select limit offset
DB --> Model : data
Model --> Controller : data
Controller --> View : show table
View --> Admin : Tampilkan Tabel Jemaat

Admin -> View : Cari / Filter (Nama/Sektor)
View -> Controller : search(query)
Controller -> Model : whereLike(query)
Model -> DB : query
DB --> Model : results
Model --> Controller : results
Controller --> View : update table
View --> Admin : Hasil Pencarian

alt Tambah Jemaat
    Admin -> View : Button Tambah
    View --> Admin : Form Wizard
    Admin -> View : Input Data Pribadi
    Admin -> View : Input Data Keluarga
    Admin -> View : Submit
    activate View
    View -> Controller : store(data)
    activate Controller
    Controller -> Model : create(data)
    activate Model
    Model -> DB : insert
    deactivate Model
    Controller --> View : success
    deactivate Controller
    View --> Admin : Jemaat Ditambahkan
    deactivate View
else Edit Jemaat
    Admin -> View : Klik Edit
    View -> Controller : edit(id)
    Controller --> View : form(data)
    Admin -> View : Ubah Data
    Admin -> View : Submit
    activate View
    View -> Controller : update(id, data)
    activate Controller
    Controller -> Model : update()
    Model -> DB : update
    Controller --> View : success
    deactivate Controller
    View --> Admin : Data Diupdate
    deactivate View
end
deactivate Admin
@enduml
```

## 7. Admin: Kelola Formulir & Pesan

```plantuml
@startuml
!theme plain
title Admin - Kelola Formulir & Pesan
actor Admin
boundary "Inbox View" as View
control "MessageController" as Controller
entity "Pesan / Formulir" as Model
database "Database" as DB
actor Client as EmailSystem

activate Admin
Admin -> View : Buka Menu Inbox
View -> Controller : index()
Controller -> Model : getAllUnread()
Model -> DB : select where status=unread
DB --> Model : data
Model --> Controller : data
Controller --> View : show list
View --> Admin : Tampilkan Daftar Pesan

alt Tipe Pesan Kontak
    Admin -> View : Klik Pesan
    View -> Controller : show(id)
    Controller --> View : detail pesan
    View --> Admin : Baca Pesan
    
    opt Balas Email
        Admin -> View : Tulis Balasan & Kirim
        activate View
        View -> Controller : reply(id, message)
        activate Controller
        Controller -> EmailSystem : sendEmail(to, message)
        activate EmailSystem
        EmailSystem --> Controller : sent
        deactivate EmailSystem
        Controller -> Model : markAsReplied(id)
        Model -> DB : update status
        Controller --> View : success
        deactivate Controller
        View --> Admin : Terkirim
        deactivate View
    end
    
    Admin -> View : Tandai Dibaca
    View -> Controller : markAsRead(id)
    Controller -> Model : updateStatus('read')
    Model -> DB : update
else Tipe Formulir Pelayanan
    Admin -> View : Klik Pengajuan Formulir
    View -> Controller : detail(id)
    Controller --> View : show detail
    Admin -> View : Review Data
    Admin -> View : Ubah Status (Terima)
    activate View
    View -> Controller : updateStatus(id, 'Dikonfirmasi')
    activate Controller
    Controller -> Model : update()
    Model -> DB : update
    Controller --> View : success
    deactivate Controller
    View --> Admin : Status Diupdate
    deactivate View
end
deactivate Admin
@enduml
```

## 8. Admin: Kelola Keuangan & Donasi

```plantuml
@startuml
!theme plain
title Admin - Kelola Keuangan & Donasi
actor Admin
boundary "Keuangan View" as View
control "KeuanganController" as Controller
entity "Transaksi" as Model
database "Database" as DB

activate Admin
Admin -> View : Menu Keuangan

alt Input Transaksi
    Admin -> View : Tambah Transaksi
    Admin -> View : Input (Pemasukan/Pengeluaran)
    Admin -> View : Simpan
    activate View
    View -> Controller : store(data)
    activate Controller
    Controller -> Model : create(data)
    Model -> DB : insert
    Controller --> View : success
    deactivate Controller
    View --> Admin : Saved
    deactivate View
else Verifikasi Donasi
    Admin -> View : Tab Donasi Masuk
    View -> Controller : listDonations()
    Controller -> Model : where(status='pending')
    Model --> Controller : list
    Controller --> View : show
    
    Admin -> View : Cek Bukti Transfer
    alt Valid
        Admin -> View : Konfirmasi
        View -> Controller : confirm(id)
        Controller -> Model : update(status='verified')
        Model -> DB : update
    else Invalid
        Admin -> View : Tolak
        View -> Controller : reject(id)
        Controller -> Model : update(status='rejected')
        Model -> DB : update
    end
else Cetak Laporan
    Admin -> View : Menu Laporan
    Admin -> View : Pilih Periode (Bulan/Tahun)
    Admin -> View : Klik Export PDF
    activate View
    View -> Controller : export(periode)
    activate Controller
    Controller -> Model : getByPeriod(periode)
    Model -> DB : select sum...
    DB --> Model : data
    Model --> Controller : data
    Controller -> Controller : generatePDF(data)
    Controller --> View : download file
    deactivate Controller
    View --> Admin : Download PDF
    deactivate View
end
deactivate Admin
@enduml
```

## 9. Admin: Kelola Pengguna Sistem

```plantuml
@startuml
!theme plain
title Admin - Kelola Pengguna Sistem
actor Admin
boundary "User Management View" as View
control "UserController" as Controller
entity "User" as Model
database "Database" as DB

activate Admin
Admin -> View : Menu User
View -> Controller : index()
Controller -> Model : all()
Model -> DB : select
DB --> Model : users
Model --> Controller : users
Controller --> View : list users
View --> Admin : Daftar User

alt Tambah User
    Admin -> View : Add New User
    Admin -> View : Input Nama, Email, Role
    Admin -> View : Generate Password
    Admin -> View : Save
    activate View
    View -> Controller : store(data)
    activate Controller
    Controller -> Model : create(data)
    Model -> DB : insert
    Controller --> View : success
    deactivate Controller
    View --> Admin : User Created
    deactivate View
else Reset Password
    Admin -> View : Pilih User -> Reset Pass
    activate View
    View -> Controller : resetPassword(id)
    activate Controller
    Controller -> Model : find(id)
    Controller -> Controller : generateNewPass()
    Controller -> Model : update(password)
    Model -> DB : update
    Controller --> View : new_password
    deactivate Controller
    View --> Admin : Tampilkan Password Baru
    deactivate View
end
deactivate Admin
@enduml
```

## 10. Pendeta Mengelola Formulir Konseling

```plantuml
@startuml
!theme plain
title Pendeta Mengelola Formulir Konseling
actor Pendeta
boundary "Dashboard Pendeta" as Dashboard
boundary "Konseling View" as View
control "KonselingController" as Controller
entity "PengajuanKonseling" as Model
database "Database" as DB

activate Pendeta
Pendeta -> Dashboard : Login & Akses
Dashboard -> View : Menu Formulir Konseling
activate View
View -> Controller : index()
activate Controller
Controller -> Model : getAssignedOrAll()
activate Model
Model -> DB : query
DB --> Model : list
deactivate DB
Model --> Controller : list
deactivate Model
Controller --> View : tample
deactivate Controller
View --> Pendeta : Daftar Pengajuan

Pendeta -> View : Pilih Pengajuan
View -> Controller : show(id)
Controller -> Model : find(id)
Model --> Controller : detail
Controller --> View : detail view
View --> Pendeta : Detail Pengajuan

    alt Kelola Status
        Pendeta -> View : Ubah Status (Jadwalkan/Selesai)
        activate View
        View -> Controller : updateStatus(id, status)
        activate Controller
        Controller -> Model : update(status)
        Model -> DB : update
        Controller --> View : success
        deactivate Controller
        View --> Pendeta : Status Berubah
        deactivate View
    else Kelola Catatan
        Pendeta -> View : Tambah/Edit Catatan Pastoral
        activate View
        View -> Controller : addNote(id, note)
        activate Controller
        Controller -> Model : appendNote(note)
        Model -> DB : update
        Controller --> View : success
        deactivate Controller
        View --> Pendeta : Catatan Tersimpan
        deactivate View
    end

deactivate Pendeta
@enduml
```
