# Wireframe Diagram (PlantUML Salt)

Berikut adalah rancangan antarmuka (UI Wireframe) untuk sistem Gereja Buntu Ambaang, mencakup 10 proses utama.
Desain menggunakan layout: **Header**, **Sidebar Menu** (untuk Admin/Pendeta), dan **Content Area**.

## 0. Halaman Publik Utama (Landing Page)

Halaman depan yang diakses pengunjung (Home, Tentang, Jadwal, Berita).

**A. Beranda (Home)**
```plantuml
@startsalt
!theme plain
title Wireframe - Beranda (Home)
{+
  <b>GEREJA BUNTU AMBAANG</b> | [Beranda] | [Tentang] | [Warta] | [Jadwal] | [Kontak] | [Login]
  ==
  {
    "           HERO IMAGE / SLIDER FOTO KEGIATAN GEREJA           "
    "         Selamat Datang di Website Resmi Gereja Buntu         "
    .
    [ Selengkapnya ]
  }
  ..
  == Jadwal Ibadah Minggu Ini ==
  {#
    <b>Hari/Tanggal</b> | <b>Pukul</b> | <b>Kegiatan</b>
    Minggu, 26 Jan     | 09:00     | Ibadah Raya 1
    Minggu, 26 Jan     | 17:00     | Ibadah Raya 2
  }
  ..
  == Berita Terbaru ==
  {
    { [Img] <b>Natal Sekolah Minggu</b> | 25 Des 2024 | "Kegiatan berjalan hikmat..." }
    { [Img] <b>Kerja Bakti Jemaat  </b> | 10 Jan 2025 | "Membersihkan halaman..."   }
  }
  --
  Footer: Alamat, Sosmed, Copyright 2025
}
@endsalt
```

**B. Halaman Daftar Berita / Warta**
```plantuml
@startsalt
!theme plain
title Wireframe - Warta Jemaat
{+
  <b>GEREJA BUNTU AMBAANG</b> | [Beranda] | [Warta] | ...
  ==
  <b>Warta & Berita Gereja</b>
  .
  {/ <b>Semua</b> | Kegiatan | Pengumuman | Renungan }
  .
  {
      [ Thumbnail Berita 1 ]
      <b>Judul Berita Pertama</b>
      "Diposting: 20 Jan 2025"
      "Ringkasan berita ditampilkan disini untuk menarik..."
      [Baca Selengkapnya]
  }
  -
  {
      [ Thumbnail Berita 2 ]
      <b>Judul Berita Kedua</b>
      "Diposting: 18 Jan 2025"
      "Ringkasan berita ditampilkan disini..."
      [Baca Selengkapnya]
  }
  .
  [ < ] 1 | 2 | 3 [ > ]
  --
  Footer
}
@endsalt
```

## 1. Pengunjung Mengisi Formulir Doa (Public View)
{+
  <b>GEREJA BUNTU AMBAANG</b> | [Beranda] | [Warta] | [Kontak] | [Login]
  ==
  {^"Formulir Permohonan Doa"
    Nama Lengkap    | "Melisa Potta         "
    Email           | "melisa@example.com   "
    No. Telepon     | "0812xxxxxxxx         "
    Kategori Doa    | ^Kesehatan^
    Pokok Doa       | "Mohon doakan...      "
    .               | "                     "
    .               | "                     "
    [X] Saya setuju dengan kebijakan privasi
    [ Kirim Permohonan ]
  }
  --
  Footer: Copyright 2025 Gereja Buntu Ambaang
}
@endsalt
```

## 2. Admin Mengelola Jadwal Ibadah

```plantuml
@startsalt
!theme plain
title Wireframe - Admin Jadwal Ibadah
{+
  {/
    <b>Admin Panel</b>
    Dashboard
    Data Jemaat
    <b>Jadwal Ibadah</b>
    Keuangan
    User
    Logout
  } |
  {
    <b>Kelola Jadwal Ibadah</b>
    [ + Tambah Jadwal Baru ]
    .
    {#
      <b>Tanggal</b> | <b>Jenis</b> | <b>Pengkhotbah</b> | <b>Aksi</b>
      26 Jan 2025 | Ibadah Raya 1 | Pdt. A | [Edit] [Hapus]
      26 Jan 2025 | Ibadah Raya 2 | Pdt. A | [Edit] [Hapus]
      02 Feb 2025 | Ibadah Raya 1 | Pdt. B | [Edit] [Hapus]
    }
  }
}
@endsalt
```

**Form Tambah/Edit Jadwal:**
```plantuml
@startsalt
!theme plain
title Form Jadwal
{+
  <b>Form Jadwal Ibadah</b>
  Tanggal       | "2025-01-26    "
  Waktu Mulai   | "09:00         "
  Jenis Ibadah  | ^Ibadah Raya^
  Pengkhotbah   | "Pdt. A        "
  Liturgis      | "Ibu. B        "
  [ Simpan Jadwal ] | [ Batal ]
}
@endsalt
```

## 3. Admin: Lihat Dashboard

```plantuml
@startsalt
!theme plain
title Wireframe - Dashboard Admin
{+
  {/
    <b>Admin Panel</b>
    <b>Dashboard</b>
    Data Jemaat
    Jadwal Ibadah
    Keuangan
    User
    Logout
  } |
  {
    <b>Dashboard Ringkasan</b>
    .
    {
       [Jemaat Aktif: 450 Orang] | [Jadwal Minggu Ini: 3] | [Saldo Kas: Rp 15.000.000]
    }
    .
    <b>Pemasukan Bulan Ini</b>
    {
      " Grafik Pemasukan "
      " [................] "
      " [................] "
    }
    .
    <b>Activity Log</b>
    {
      - User A menambahkan jemaat baru
      - User B mengupdate jadwal
    }
  }
}
@endsalt
```

## 4. Admin: Kelola OIG & Kegiatan

```plantuml
@startsalt
!theme plain
title Wireframe - Admin OIG & Kegiatan
{+
  {/
     <b>Admin Panel</b>
     Dashboard
     <b>Kegiatan/OIG</b>
     Data Jemaat
     Keuangan
     Logout
  } |
  {
    <b>Daftar Kegiatan & OIG</b>
    [ + Tambah Kegiatan ]
    .
    {#
      <b>Nama Kegiatan</b> | <b>Tanggal</b> | <b>Kategori</b> | <b>Foto</b> | <b>Aksi</b>
      Natal Sekolah Minggu | 25 Des 2024 | Sekolah Minggu | [Lihat] | [Edit] [Hapus]
      Kaum Bapak         | Rutin       | PKB            | [Lihat] | [Edit] [Hapus]
    }
  }
}
@endsalt
```

## 5. Admin: Kelola Berita & Pengumuman

```plantuml
@startsalt
!theme plain
title Wireframe - Admin Berita
{+
  {/
    <b>Admin Panel</b>
    Dashboard
    <b>Berita</b>
    Data Jemaat
    Keuangan
    Logout
  } |
  {
    <b>Kelola Berita & Pengumuman</b>
    [ + Tulis Berita ]
    .
    {#
      <b>Judul</b> | <b>Tanggal</b> | <b>Status</b> | <b>Aksi</b>
      Jadwal Ibadah Natal | 24 Des 2024 | Publish | [Edit] [Hapus]
      Renungan Minggu     | 18 Jan 2025 | Draft   | [Edit] [Hapus]
    }
  }
}
@endsalt
```

**Form Editor Berita:**
```plantuml
@startsalt
!theme plain
title Form Berita
{+
  <b>Editor Berita</b>
  Judul     | "Jadwal Ibadah Natal "
  Kategori  | ^Warta Jemaat^
  Konten    | "Isi berita disini..."
  .         | "                    "
  .         | "                    "
  Gambar    | [ Choose File ] img.jpg
  Status    | (O) Publish  ( ) Draft
  [ Simpan Berita ]
}
@endsalt
```

## 6. Admin: Kelola Data Jemaat

```plantuml
@startsalt
!theme plain
title Wireframe - Admin Data Jemaat
{+
  {/
    <b>Admin Panel</b>
    Dashboard
    <b>Data Jemaat</b>
    Jadwal Ibadah
    Keuangan
    Logout
  } |
  {
    <b>Data Jemaat</b>
    Search: "Cari Nama/Sektor...      " [Cari]
    [ + Tambah Jemaat ] [ Export Excel ]
    .
    {#
      <b>No. Induk</b> | <b>Nama Lengkap</b> | <b>Sektor</b> | <b>Status</b> | <b>Aksi</b>
      001        | Bpk. Andre      | Sektor 1 | Aktif  | [Detail] [Edit]
      002        | Ibu. Susi       | Sektor 2 | Aktif  | [Detail] [Edit]
    }
  }
}
@endsalt
```

## 7. Admin: Kelola Formulir & Pesan

```plantuml
@startsalt
!theme plain
title Wireframe - Inbox Pesan
{+
  {/
    <b>Admin Panel</b>
    Dashboard
    <b>Pesan Masuk</b>
    Data Jemaat
    Keuangan
    Logout
  } |
  {
    <b>Inbox Pesan & Permohonan</b>
    .
    {/ <b>Pesan Kontak</b> | Formulir Pelayanan | Permohonan Doa }
    .
    {#
      <b>Pengirim</b> | <b>Subjek</b> | <b>Tanggal</b> | <b>Status</b>
      Melisa     | Tanya Jadwal | 22/01/25| [Read]
      Budi       | Pelayanan    | 20/01/25| [Unread]
    }
    .
    <b>Preview Pesan:</b>
    "Halo admin, saya ingin bertanya..."
    [ Balas Email ] [ Hapus ]
  }
}
@endsalt
```

## 8. Admin: Kelola Keuangan & Donasi

```plantuml
@startsalt
!theme plain
title Wireframe - Admin Keuangan
{+
  {/
    <b>Admin Panel</b>
    Dashboard
    Data Jemaat
    <b>Keuangan</b>
    User
    Logout
  } |
  {
    <b>Laporan Keuangan</b>
    Periode: ^Januari 2025^ [Filter] [Cetak Laporan]
    .
    <b>Pemasukan:</b> Rp 10.000.000
    <b>Pengeluaran:</b> Rp 2.000.000
    .
    [ + Input Transaksi ] [ Verifikasi Donasi (2 New) ]
    .
    {#
      <b>Tanggal</b> | <b>Keterangan</b> | <b>Masuk</b> | <b>Keluar</b> | <b>Saldo</b>
      01/01/25 | Kolekte Minggu 1 | 5.000.000 | - | 5.000.000
      02/01/25 | Bayar Listrik    | - | 1.000.000 | 4.000.000
    }
  }
}
@endsalt
```

## 9. Admin: Kelola Pengguna Sistem

```plantuml
@startsalt
!theme plain
title Wireframe - Admin User Management
{+
  {/
    <b>Admin Panel</b>
    Dashboard
    Data Jemaat
    Keuangan
    <b>User Management</b>
    Logout
  } |
  {
    <b>Daftar Pengguna Sistem</b>
    [ + Tambah User ]
    .
    {#
      <b>Nama</b> | <b>Email</b> | <b>Role</b> | <b>Aksi</b>
      Admin Utama | admin@gba.com | Super Admin | [Edit]
      Pdt. A      | pdt@gba.com   | Pendeta     | [Edit] [Reset Pass]
    }
  }
}
@endsalt
```

## 10. Pendeta Mengelola Formulir Konseling

```plantuml
@startsalt
!theme plain
title Wireframe - Dashboard Pendeta
{+
  {/ <b>Area Pendeta</b> | Dashboard | <b>Konseling</b> | Jadwal Saya | Logout }
  {
    <b>Daftar Pengajuan Konseling</b>
    .
    {#
      <b>Jemaat</b> | <b>Topik</b> | <b>Tgl Request</b> | <b>Status</b> | <b>Aksi</b>
      Sdr. Andi | Masalah Keluarga | 20/01/25 | Pending | [Proses]
      Sdri. Ani | Persiapan Nikah  | 21/01/25 | Dijadwalkan | [Detail]
    }
    .
    <b>Detail Konseling (Sdr. Andi)</b>
    Status: ^Dijadwalkan^
    Catatan Pastoral:
    "Sudah dihubungi, jadwal Rabu jam 10..."
    "                                      "
    [ Simpan Perubahan ]
  }
}
@endsalt
```
