<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use App\Models\User;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Hash;

class AuthController extends Controller
{
    public function showLogin()
    {
        if (Auth::check()) {
            return $this->redirectByRole(Auth::user());
        }
        return view('admin.login');
    }

    public function login(Request $request)
    {
        $request->validate([
            'username' => 'required',
            'password' => 'required',
        ]);

        $credentials = [
            'email' => $request->username,
            'password' => $request->password,
        ];

        if (Auth::attempt($credentials, $request->filled('remember'))) {
            $request->session()->regenerate();
            $user = Auth::user();

            if (!$user->is_active) {
                Auth::logout();
                return back()->with('error', 'Akun Anda tidak aktif. Hubungi administrator.');
            }

            return $this->redirectByRole($user);
        }

        // Fallback: prototype login untuk development
        if ($request->username === 'admin' && $request->password === 'admin123') {
            $user = User::where('email', 'admin@gereja.com')->first();
            if (!$user) {
                $user = User::create([
                    'name' => 'Administrator',
                    'email' => 'admin@gereja.com',
                    'password' => Hash::make('admin123'),
                    'role' => 'admin',
                    'is_active' => true,
                ]);
            }
            Auth::login($user);
            return redirect()->route('admin.dashboard');
        }

        return back()->with('error', 'Email atau password salah.');
    }

    public function logout(Request $request)
    {
        Auth::logout();
        $request->session()->invalidate();
        $request->session()->regenerateToken();
        return redirect()->route('admin.login');
    }

    protected function redirectByRole($user)
    {
        if ($user->isPendeta()) {
            return redirect()->route('pendeta.dashboard');
        }
        return redirect()->route('admin.dashboard');
    }
}
