<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use App\Models\Donasi;
use Illuminate\Http\Request;

class DonasiController extends Controller
{
    public function index()
    {
        $donasiList = Donasi::orderBy('created_at', 'desc')->paginate(10);

        $totalDonasi = Donasi::where('status', 'dikonfirmasi')->sum('jumlah');
        $totalPending = Donasi::where('status', 'pending')->count();

        return view('admin.donasi.index', compact('donasiList', 'totalDonasi', 'totalPending'));
    }

    public function create()
    {
        return view('admin.donasi.form');
    }

    public function store(Request $request)
    {
        $request->validate([
            'nama' => 'required|string|max:255',
            'telepon' => 'required|string|max:20',
            'jumlah' => 'required|numeric|min:0',
            'tujuan' => 'required|in:persembahan,diakonia,pembangunan',
            'tanggal_transfer' => 'required|date',
            'status' => 'required|in:pending,dikonfirmasi,ditolak',
        ]);

        Donasi::create([
            'nama' => $request->nama,
            'telepon' => $request->telepon,
            'jumlah' => $request->jumlah,
            'tujuan' => $request->tujuan,
            'tanggal_transfer' => $request->tanggal_transfer,
            'status' => $request->status,
        ]);

        return redirect()->route('admin.donasi.index')->with('success', 'Donasi berhasil ditambahkan.');
    }

    public function edit($id)
    {
        $donasi = Donasi::findOrFail($id);
        return view('admin.donasi.form', compact('donasi'));
    }

    public function update(Request $request, $id)
    {
        $request->validate([
            'nama' => 'required|string|max:255',
            'telepon' => 'required|string|max:20',
            'jumlah' => 'required|numeric|min:0',
            'tujuan' => 'required|in:persembahan,diakonia,pembangunan',
            'tanggal_transfer' => 'required|date',
            'status' => 'required|in:pending,dikonfirmasi,ditolak',
        ]);

        $donasi = Donasi::findOrFail($id);
        $donasi->update([
            'nama' => $request->nama,
            'telepon' => $request->telepon,
            'jumlah' => $request->jumlah,
            'tujuan' => $request->tujuan,
            'tanggal_transfer' => $request->tanggal_transfer,
            'status' => $request->status,
        ]);

        return redirect()->route('admin.donasi.index')->with('success', 'Donasi berhasil diupdate.');
    }

    public function destroy($id)
    {
        Donasi::findOrFail($id)->delete();
        return redirect()->route('admin.donasi.index')->with('success', 'Donasi berhasil dihapus.');
    }

    public function updateStatus(Request $request, $id)
    {
        $request->validate([
            'status' => 'required|in:pending,dikonfirmasi,ditolak',
        ]);

        $donasi = Donasi::findOrFail($id);
        $donasi->update(['status' => $request->status]);

        return redirect()->route('admin.donasi.index')->with('success', 'Status donasi berhasil diupdate.');
    }
}
