<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use App\Models\FormulirDoa;
use App\Models\FormulirPendaftaran;
use App\Models\FormulirKonseling;

class FormulirController extends Controller
{
    public function index()
    {
        // Ambil data dari database
        $permohonanDoa = FormulirDoa::with('notes.user')->orderBy('created_at', 'desc')->get()->map(function ($item) {
            return [
                'id' => $item->id,
                'kode' => $item->kode,
                'nama' => $item->nama,
                'telepon' => $item->telepon,
                'email' => $item->email,
                'tanggal' => $item->created_at->translatedFormat('d M Y'),
                'kategori' => ucfirst($item->kategori),
                'permohonan' => $item->permohonan,
                'status' => $item->status,
                'privasi' => $item->privasi,
                'notes' => $item->notes->map(function ($note) {
                    return [
                        'user_nama' => $note->user->name ?? 'User',
                        'user_role' => $note->user->role ?? '-',
                        'catatan' => $note->catatan,
                        'waktu' => $note->created_at->diffForHumans(),
                    ];
                }),
            ];
        })->toArray();

        $pendaftaran = FormulirPendaftaran::with(['kegiatan', 'notes.user'])->orderBy('created_at', 'desc')->get()->map(function ($item) {
            return [
                'id' => $item->id,
                'kode' => $item->kode,
                'nama' => $item->nama,
                'telepon' => $item->telepon,
                'email' => $item->email,
                'kegiatan' => $item->kegiatan->nama ?? ($item->nama_kegiatan ?? '-'),
                'tanggal' => $item->created_at->translatedFormat('d M Y'),
                'usia' => $item->usia,
                'notes' => $item->notes->map(function ($note) {
                    return [
                        'user_nama' => $note->user->name ?? 'User',
                        'user_role' => $note->user->role ?? '-',
                        'catatan' => $note->catatan,
                        'waktu' => $note->created_at->diffForHumans(),
                    ];
                }),
            ];
        })->toArray();

        $konseling = FormulirKonseling::with('notes.user')->orderBy('created_at', 'desc')->get()->map(function ($item) {
            return [
                'id' => $item->id,
                'kode' => $item->kode,
                'nama' => $item->nama,
                'telepon' => $item->telepon,
                'jenis_kelamin' => $item->jenis_kelamin,
                'kategori' => ucfirst($item->kategori),
                'gambaran' => $item->gambaran,
                'metode' => $item->metode,
                'waktu' => $item->waktu_diinginkan,
                'status' => $item->status ?? 'pending',
                'tanggal' => $item->created_at->translatedFormat('d M Y'),
                'notes' => $item->notes->map(function ($note) {
                    return [
                        'user_nama' => $note->user->name ?? 'User',
                        'user_role' => $note->user->role ?? '-',
                        'catatan' => $note->catatan,
                        'waktu' => $note->created_at->diffForHumans(),
                    ];
                }),
            ];
        })->toArray();

        return view('admin.formulir.index', compact('permohonanDoa', 'pendaftaran', 'konseling'));
    }

    public function updateStatusDoa($id, $status)
    {
        $formulir = FormulirDoa::findOrFail($id);
        $formulir->update(['status' => $status]);
        return redirect()->back()->with('success', 'Status permohonan doa berhasil diupdate.');
    }

    public function deleteDoa($id)
    {
        FormulirDoa::findOrFail($id)->delete();
        return redirect()->back()->with('success', 'Permohonan doa berhasil dihapus.');
    }

    public function deletePendaftaran($id)
    {
        FormulirPendaftaran::findOrFail($id)->delete();
        return redirect()->back()->with('success', 'Pendaftaran berhasil dihapus.');
    }

    public function deleteKonseling($id)
    {
        FormulirKonseling::findOrFail($id)->delete();
        return redirect()->back()->with('success', 'Permohonan konseling berhasil dihapus.');
    }

    public function updateStatusKonseling($id, $status)
    {
        $formulir = FormulirKonseling::findOrFail($id);
        $formulir->update(['status' => $status]);
        return redirect()->back()->with('success', 'Status konseling berhasil diupdate.');
    }

    public function updateCatatanKonseling(\Illuminate\Http\Request $request, $id)
    {
        $formulir = FormulirKonseling::findOrFail($id);
        $formulir->notes()->create([
            'catatan' => $request->catatan,
            'user_id' => auth()->id(),
        ]);
        return redirect()->back()->with('success', 'Catatan konseling berhasil disimpan.');
    }

    public function updateCatatanDoa(\Illuminate\Http\Request $request, $id)
    {
        $formulir = FormulirDoa::findOrFail($id);
        $formulir->notes()->create([
            'catatan' => $request->catatan,
            'user_id' => auth()->id(),
        ]);
        return redirect()->back()->with('success', 'Catatan doa berhasil disimpan.');
    }

    public function updateCatatanPendaftaran(\Illuminate\Http\Request $request, $id)
    {
        $formulir = FormulirPendaftaran::findOrFail($id);
        $formulir->notes()->create([
            'catatan' => $request->catatan,
            'user_id' => auth()->id(),
        ]);
        return redirect()->back()->with('success', 'Catatan pendaftaran berhasil disimpan.');
    }
}
