<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use App\Models\JadwalIbadah;
use Illuminate\Http\Request;
use Carbon\Carbon;

class IbadahKhususController extends Controller
{
    public function index()
    {
        $jadwalList = JadwalIbadah::khusus()
            ->orderBy('tanggal', 'desc')
            ->paginate(10);

        return view('admin.ibadah-khusus.index', compact('jadwalList'));
    }

    public function create()
    {
        return view('admin.ibadah-khusus.form');
    }

    public function store(Request $request)
    {
        $request->validate([
            'nama' => 'required|string|max:255',
            'kategori' => 'nullable|string|max:100',
            'tanggal' => 'required|date',
            'waktu' => 'required',
            'tempat' => 'required|string|max:255',
            'pelayan' => 'nullable|string|max:255',
        ]);

        JadwalIbadah::create([
            'nama' => $request->nama,
            'hari' => Carbon::parse($request->tanggal)->translatedFormat('l'),
            'waktu' => $request->waktu,
            'tempat' => $request->tempat,
            'pelayan' => $request->pelayan,
            'online' => $request->has('online'),
            'tipe' => 'khusus',
            'kategori' => $request->kategori,
            'tanggal' => $request->tanggal,
            'aktif' => $request->has('aktif'),
        ]);

        return redirect()->route('admin.ibadah-khusus.index')->with('success', 'Ibadah khusus berhasil ditambahkan.');
    }

    public function edit($id)
    {
        $jadwal = JadwalIbadah::khusus()->findOrFail($id);
        return view('admin.ibadah-khusus.form', compact('jadwal'));
    }

    public function update(Request $request, $id)
    {
        $request->validate([
            'nama' => 'required|string|max:255',
            'kategori' => 'nullable|string|max:100',
            'tanggal' => 'required|date',
            'waktu' => 'required',
            'tempat' => 'required|string|max:255',
            'pelayan' => 'nullable|string|max:255',
        ]);

        $jadwal = JadwalIbadah::khusus()->findOrFail($id);

        $jadwal->update([
            'nama' => $request->nama,
            'hari' => Carbon::parse($request->tanggal)->translatedFormat('l'),
            'waktu' => $request->waktu,
            'tempat' => $request->tempat,
            'pelayan' => $request->pelayan,
            'online' => $request->has('online'),
            'kategori' => $request->kategori,
            'tanggal' => $request->tanggal,
            'aktif' => $request->has('aktif'),
        ]);

        return redirect()->route('admin.ibadah-khusus.index')->with('success', 'Ibadah khusus berhasil diperbarui.');
    }

    public function destroy($id)
    {
        $jadwal = JadwalIbadah::khusus()->findOrFail($id);
        $jadwal->delete();

        return redirect()->route('admin.ibadah-khusus.index')->with('success', 'Ibadah khusus berhasil dihapus.');
    }
}
