<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use App\Models\Keuangan;
use Illuminate\Http\Request;

class KeuanganController extends Controller
{
    public function index()
    {
        $totalPemasukan = Keuangan::getTotalPemasukan();
        $totalPengeluaran = Keuangan::getTotalPengeluaran();
        $saldo = $totalPemasukan - $totalPengeluaran;

        $transaksi = Keuangan::orderBy('tanggal', 'desc')->orderBy('created_at', 'desc')->get()->map(function ($item) {
            return [
                'id' => $item->id,
                'tanggal' => $item->tanggal->translatedFormat('d M Y'),
                'kategori' => $item->kategori,
                'keterangan' => $item->keterangan,
                'jumlah' => $item->jumlah,
                'type' => $item->tipe,
            ];
        })->toArray();

        return view('admin.keuangan.index', compact('totalPemasukan', 'totalPengeluaran', 'saldo', 'transaksi'));
    }

    public function store(Request $request)
    {
        $request->validate([
            'type' => 'required|in:pemasukan,pengeluaran',
            'kategori' => 'required|string|max:255',
            'jumlah' => 'required|numeric|min:0',
            'tanggal' => 'required|date',
        ]);

        Keuangan::create([
            'tipe' => $request->type,
            'kategori' => $request->kategori,
            'keterangan' => $request->keterangan,
            'jumlah' => $request->jumlah,
            'tanggal' => $request->tanggal,
            'periode' => date('Y-m', strtotime($request->tanggal)),
        ]);

        return redirect()->route('admin.keuangan.index')->with('success', 'Transaksi berhasil ditambahkan.');
    }

    public function destroy($id)
    {
        Keuangan::findOrFail($id)->delete();
        return redirect()->route('admin.keuangan.index')->with('success', 'Transaksi berhasil dihapus.');
    }

    public function export()
    {
        return redirect()->route('admin.keuangan.index')->with('success', 'Laporan keuangan berhasil di-export.');
    }
}
