<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use App\Models\Komunikasi;
use Illuminate\Http\Request;

class KomunikasiController extends Controller
{
    public function index()
    {
        $meetings = Komunikasi::orderBy('tanggal', 'desc')->orderBy('waktu')->get()->map(function ($item) {
            return [
                'id' => $item->id,
                'nama' => $item->nama,
                'deskripsi' => $item->deskripsi,
                'hari' => $item->hari,
                'tanggal' => $item->tanggal ? $item->tanggal->translatedFormat('d M Y') : '-',
                'waktu' => $item->waktu ? substr($item->waktu, 0, 5) : '-',
                'platform' => $item->platform,
                'zoom_link' => $item->zoom_link,
                'meet_link' => $item->meet_link,
                'is_active' => $item->is_active,
                'catatan' => $item->catatan,
            ];
        })->toArray();

        return view('admin.komunikasi.index', compact('meetings'));
    }

    public function create()
    {
        return view('admin.komunikasi.form');
    }

    public function store(Request $request)
    {
        $request->validate([
            'nama' => 'required|string|max:255',
            'hari' => 'required|string',
            'waktu' => 'required',
            'platform' => 'required|string',
        ]);

        Komunikasi::create([
            'nama' => $request->nama,
            'deskripsi' => $request->deskripsi,
            'hari' => $request->hari,
            'tanggal' => $request->tanggal,
            'waktu' => $request->waktu,
            'platform' => $request->platform,
            'zoom_link' => $request->zoom_link,
            'meet_link' => $request->meet_link,
            'is_active' => $request->has('is_active'),
            'catatan' => $request->catatan,
        ]);

        return redirect()->route('admin.komunikasi.index')->with('success', 'Meeting berhasil ditambahkan.');
    }

    public function edit($id)
    {
        $meeting = Komunikasi::findOrFail($id);
        $meetingData = [
            'id' => $meeting->id,
            'nama' => $meeting->nama,
            'deskripsi' => $meeting->deskripsi,
            'hari' => $meeting->hari,
            'tanggal' => $meeting->tanggal ? $meeting->tanggal->format('Y-m-d') : null,
            'waktu' => $meeting->waktu ? substr($meeting->waktu, 0, 5) : null,
            'platform' => $meeting->platform,
            'zoom_link' => $meeting->zoom_link,
            'meet_link' => $meeting->meet_link,
            'is_active' => $meeting->is_active,
            'catatan' => $meeting->catatan,
        ];
        return view('admin.komunikasi.form', ['meeting' => $meetingData]);
    }

    public function update(Request $request, $id)
    {
        $request->validate([
            'nama' => 'required|string|max:255',
            'hari' => 'required|string',
            'waktu' => 'required',
            'platform' => 'required|string',
        ]);

        $meeting = Komunikasi::findOrFail($id);
        $meeting->update([
            'nama' => $request->nama,
            'deskripsi' => $request->deskripsi,
            'hari' => $request->hari,
            'tanggal' => $request->tanggal,
            'waktu' => $request->waktu,
            'platform' => $request->platform,
            'zoom_link' => $request->zoom_link,
            'meet_link' => $request->meet_link,
            'is_active' => $request->has('is_active'),
            'catatan' => $request->catatan,
        ]);

        return redirect()->route('admin.komunikasi.index')->with('success', 'Meeting berhasil diupdate.');
    }

    public function destroy($id)
    {
        Komunikasi::findOrFail($id)->delete();
        return redirect()->route('admin.komunikasi.index')->with('success', 'Meeting berhasil dihapus.');
    }
}
