<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use App\Models\Oig;
use Illuminate\Http\Request;
use Illuminate\Support\Str;

class OigController extends Controller
{
    public function index()
    {
        $oigList = Oig::orderBy('nama')->get()->map(function ($item) {
            $pengurus = $item->pengurus ?? [];
            $ketua = collect($pengurus)->firstWhere('jabatan', 'Ketua');
            
            return [
                'id' => $item->id,
                'nama' => $item->nama,
                'slug' => $item->slug,
                'ketua' => $ketua['nama'] ?? '-',
                'jadwal' => $item->jadwal,
                'deskripsi' => $item->deskripsi,
            ];
        })->toArray();

        return view('admin.oig.index', compact('oigList'));
    }

    public function create()
    {
        return view('admin.oig.form');
    }

    public function store(Request $request)
    {
        $request->validate([
            'nama' => 'required|string|max:255',
        ]);

        $pengurus = [];
        if ($request->pengurus_nama) {
            foreach ($request->pengurus_nama as $index => $nama) {
                if ($nama) {
                    $pengurus[] = [
                        'nama' => $nama,
                        'jabatan' => $request->pengurus_jabatan[$index] ?? '',
                    ];
                }
            }
        }

        Oig::create([
            'nama' => $request->nama,
            'slug' => Str::slug($request->nama),
            'deskripsi' => $request->deskripsi,
            'jadwal' => $request->jadwal,
            'pengurus' => $pengurus,
        ]);

        return redirect()->route('admin.oig.index')->with('success', 'OIG berhasil ditambahkan.');
    }

    public function edit($id)
    {
        $oig = Oig::findOrFail($id);
        return view('admin.oig.form', compact('oig'));
    }

    public function update(Request $request, $id)
    {
        $request->validate([
            'nama' => 'required|string|max:255',
        ]);

        $pengurus = [];
        if ($request->pengurus_nama) {
            foreach ($request->pengurus_nama as $index => $nama) {
                if ($nama) {
                    $pengurus[] = [
                        'nama' => $nama,
                        'jabatan' => $request->pengurus_jabatan[$index] ?? '',
                    ];
                }
            }
        }

        $oig = Oig::findOrFail($id);
        $oig->update([
            'nama' => $request->nama,
            'slug' => Str::slug($request->nama),
            'deskripsi' => $request->deskripsi,
            'jadwal' => $request->jadwal,
            'pengurus' => $pengurus,
        ]);

        return redirect()->route('admin.oig.index')->with('success', 'OIG berhasil diupdate.');
    }

    public function destroy($id)
    {
        Oig::findOrFail($id)->delete();
        return redirect()->route('admin.oig.index')->with('success', 'OIG berhasil dihapus.');
    }
}
