<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use App\Models\Pengumuman;
use Illuminate\Http\Request;

class PengumumanController extends Controller
{
    public function index()
    {
        $pengumumanList = Pengumuman::orderBy('tanggal', 'desc')->paginate(10);
        $totalAktif = Pengumuman::where('aktif', true)->count();
        
        return view('admin.pengumuman.index', compact('pengumumanList', 'totalAktif'));
    }

    public function create()
    {
        return view('admin.pengumuman.form');
    }

    public function store(Request $request)
    {
        $validated = $request->validate([
            'judul' => 'required|string|max:255',
            'deskripsi' => 'required|string',
            'tanggal' => 'required|date',
            'aktif' => 'nullable|boolean',
        ]);

        $validated['aktif'] = $request->has('aktif');

        Pengumuman::create($validated);

        return redirect()->route('admin.pengumuman.index')->with('success', 'Pengumuman berhasil ditambahkan!');
    }

    public function edit($id)
    {
        $pengumuman = Pengumuman::findOrFail($id);
        
        return view('admin.pengumuman.form', compact('pengumuman'));
    }

    public function update(Request $request, $id)
    {
        $pengumuman = Pengumuman::findOrFail($id);

        $validated = $request->validate([
            'judul' => 'required|string|max:255',
            'deskripsi' => 'required|string',
            'tanggal' => 'required|date',
            'aktif' => 'nullable|boolean',
        ]);

        $validated['aktif'] = $request->has('aktif');

        $pengumuman->update($validated);

        return redirect()->route('admin.pengumuman.index')->with('success', 'Pengumuman berhasil diperbarui!');
    }

    public function destroy($id)
    {
        $pengumuman = Pengumuman::findOrFail($id);
        $pengumuman->delete();

        return redirect()->route('admin.pengumuman.index')->with('success', 'Pengumuman berhasil dihapus!');
    }

    public function toggleStatus($id)
    {
        $pengumuman = Pengumuman::findOrFail($id);
        $pengumuman->aktif = !$pengumuman->aktif;
        $pengumuman->save();

        $status = $pengumuman->aktif ? 'diaktifkan' : 'dinonaktifkan';
        
        return redirect()->route('admin.pengumuman.index')->with('success', "Pengumuman berhasil {$status}!");
    }
}
