<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use App\Models\PesanKontak;
use Illuminate\Http\Request;

class PesanController extends Controller
{
    public function index()
    {
        $pesanList = PesanKontak::terbaru()->paginate(10);
        $totalBelumDibaca = PesanKontak::jumlahBelumDibaca();
        
        return view('admin.pesan.index', compact('pesanList', 'totalBelumDibaca'));
    }

    public function show($id)
    {
        $pesan = PesanKontak::findOrFail($id);
        
        // Tandai sebagai dibaca saat dibuka
        if (!$pesan->dibaca) {
            $pesan->tandaiDibaca();
        }
        
        return view('admin.pesan.show', compact('pesan'));
    }

    public function toggleStatus($id)
    {
        $pesan = PesanKontak::findOrFail($id);
        
        if ($pesan->dibaca) {
            $pesan->tandaiBelumDibaca();
            $message = 'Pesan ditandai sebagai belum dibaca';
        } else {
            $pesan->tandaiDibaca();
            $message = 'Pesan ditandai sebagai sudah dibaca';
        }
        
        return redirect()->back()->with('success', $message);
    }

    public function destroy($id)
    {
        $pesan = PesanKontak::findOrFail($id);
        $pesan->delete();

        return redirect()->route('admin.pesan.index')->with('success', 'Pesan berhasil dihapus!');
    }
}
