<?php

namespace App\Http\Controllers\Pendeta;

use App\Http\Controllers\Controller;
use App\Models\Jemaat;
use App\Models\FormulirDoa;
use App\Models\FormulirKonseling;
use App\Models\PesanKontak;
use App\Models\Berita;
use App\Models\Pengumuman;
use App\Models\JadwalIbadah;
use Carbon\Carbon;

class DashboardController extends Controller
{
    public function index()
    {
        $totalJemaat = Jemaat::aktif()->count();
        $permohonanDoa = FormulirDoa::where('status', 'baru')->count();
        $konselingPending = FormulirKonseling::where('status', 'pending')->count();
        $pesanBelumDibaca = PesanKontak::jumlahBelumDibaca();

        $notifikasi = collect();

        $doaBaru = FormulirDoa::where('status', 'baru')
            ->orderBy('created_at', 'desc')
            ->take(3)
            ->get()
            ->map(function ($item) {
                return [
                    'type' => 'doa',
                    'pesan' => 'Permohonan doa dari ' . $item->nama,
                    'waktu' => $item->created_at->diffForHumans(),
                ];
            });

        $konselingBaru = FormulirKonseling::where('status', 'pending')
            ->orderBy('created_at', 'desc')
            ->take(2)
            ->get()
            ->map(function ($item) {
                return [
                    'type' => 'konseling',
                    'pesan' => 'Permohonan konseling dari ' . $item->nama,
                    'waktu' => $item->created_at->diffForHumans(),
                ];
            });

        $pesanBaru = PesanKontak::belumDibaca()
            ->orderBy('created_at', 'desc')
            ->take(2)
            ->get()
            ->map(function ($item) {
                return [
                    'type' => 'pesan',
                    'pesan' => 'Pesan dari ' . $item->nama . ': ' . $item->subjek,
                    'waktu' => $item->created_at->diffForHumans(),
                ];
            });

        $notifikasi = $doaBaru->concat($konselingBaru)->concat($pesanBaru)
            ->sortByDesc('waktu')
            ->take(5)
            ->values()
            ->toArray();

        $jadwalMingguIni = JadwalIbadah::where('aktif', true)
            ->orderBy('hari')
            ->orderBy('waktu')
            ->take(5)
            ->get()
            ->map(function ($item) {
                $hariMap = ['Minggu' => 0, 'Senin' => 1, 'Selasa' => 2, 'Rabu' => 3, 'Kamis' => 4, 'Jumat' => 5, 'Sabtu' => 6];
                $hariIndex = $hariMap[$item->hari] ?? 0;
                $tanggal = Carbon::now()->startOfWeek()->addDays($hariIndex);
                
                return [
                    'nama' => $item->nama,
                    'tanggal' => $item->hari . ', ' . $tanggal->format('d M'),
                    'waktu' => substr($item->waktu, 0, 5),
                    'pelayan' => $item->pelayan ?? '-',
                ];
            })->toArray();

        return view('pendeta.dashboard', compact(
            'totalJemaat',
            'permohonanDoa',
            'konselingPending',
            'pesanBelumDibaca',
            'notifikasi',
            'jadwalMingguIni'
        ));
    }
}
