<?php

namespace App\Http\Controllers\Pendeta;

use App\Http\Controllers\Controller;
use App\Models\FormulirDoa;
use App\Models\FormulirKonseling;

class FormulirController extends Controller
{
    public function index()
    {
        $permohonanDoa = FormulirDoa::with('notes.user')->orderBy('created_at', 'desc')->get()->map(function ($item) {
            return [
                'id' => $item->id,
                'kode' => $item->kode,
                'nama' => $item->nama,
                'telepon' => $item->telepon,
                'kategori' => $item->kategori,
                'permohonan' => $item->permohonan,
                'privasi' => $item->privasi,
                'status' => $item->status,
                'tanggal' => $item->created_at->translatedFormat('d M Y'),
                'notes' => $item->notes->map(function ($note) {
                    return [
                        'user_nama' => $note->user->name ?? 'User',
                        'user_role' => $note->user->role ?? '-',
                        'catatan' => $note->catatan,
                        'waktu' => $note->created_at->diffForHumans(),
                    ];
                }),
            ];
        })->toArray();

        $konseling = FormulirKonseling::with('notes.user')->orderBy('created_at', 'desc')->get()->map(function ($item) {
            return [
                'id' => $item->id,
                'kode' => $item->kode,
                'nama' => $item->nama,
                'telepon' => $item->telepon,
                'jenis_kelamin' => $item->jenis_kelamin,
                'kategori' => $item->kategori,
                'metode' => $item->metode,
                'waktu' => $item->waktu_diinginkan,
                'gambaran' => $item->gambaran,
                'status' => $item->status,
                'tanggal' => $item->created_at->translatedFormat('d M Y'),
                'notes' => $item->notes->map(function ($note) {
                    return [
                        'user_nama' => $note->user->name ?? 'User',
                        'user_role' => $note->user->role ?? '-',
                        'catatan' => $note->catatan,
                        'waktu' => $note->created_at->diffForHumans(),
                    ];
                }),
            ];
        })->toArray();

        return view('pendeta.formulir.index', compact('permohonanDoa', 'konseling'));
    }

    public function updateStatusDoa($id, $status)
    {
        $formulir = FormulirDoa::findOrFail($id);
        $formulir->update(['status' => $status]);
        return redirect()->back()->with('success', 'Status permohonan doa berhasil diupdate.');
    }

    public function deleteDoa($id)
    {
        FormulirDoa::findOrFail($id)->delete();
        return redirect()->back()->with('success', 'Permohonan doa berhasil dihapus.');
    }

    public function updateStatusKonseling($id, $status)
    {
        $formulir = FormulirKonseling::findOrFail($id);
        $formulir->update(['status' => $status]);
        return redirect()->back()->with('success', 'Status konseling berhasil diupdate.');
    }

    public function updateCatatanKonseling(\Illuminate\Http\Request $request, $id)
    {
        $formulir = FormulirKonseling::findOrFail($id);
        $formulir->notes()->create([
            'catatan' => $request->catatan,
            'user_id' => auth()->id(),
        ]);
        return redirect()->back()->with('success', 'Catatan konseling berhasil disimpan.');
    }

    public function deleteKonseling($id)
    {
        FormulirKonseling::findOrFail($id)->delete();
        return redirect()->back()->with('success', 'Permohonan konseling berhasil dihapus.');
    }

    public function updateCatatanDoa(\Illuminate\Http\Request $request, $id)
    {
        $formulir = FormulirDoa::findOrFail($id);
        $formulir->notes()->create([
            'catatan' => $request->catatan,
            'user_id' => auth()->id(),
        ]);
        return redirect()->back()->with('success', 'Catatan doa berhasil disimpan.');
    }
}
