<?php

namespace App\Http\Controllers\Pendeta;

use App\Http\Controllers\Controller;
use App\Models\Jemaat;

class JemaatController extends Controller
{
    public function index()
    {
        $jemaatAktif = Jemaat::aktif()->orderBy('nama')->paginate(10);
        $totalJemaat = Jemaat::aktif()->count();

        return view('pendeta.jemaat.index', compact('jemaatAktif', 'totalJemaat'));
    }

    public function show($id)
    {
        $jemaat = Jemaat::findOrFail($id);
        return view('pendeta.jemaat.show', compact('jemaat'));
    }
}
