<?php

namespace App\Http\Controllers\Pendeta;

use App\Http\Controllers\Controller;
use App\Models\PesanKontak;

class PesanController extends Controller
{
    public function index()
    {
        $pesanList = PesanKontak::terbaru()->paginate(10);
        $totalBelumDibaca = PesanKontak::jumlahBelumDibaca();

        return view('pendeta.pesan.index', compact('pesanList', 'totalBelumDibaca'));
    }

    public function show($id)
    {
        $pesan = PesanKontak::findOrFail($id);
        return view('pendeta.pesan.show', compact('pesan'));
    }
}
