<?php

namespace App\Http\Controllers\PublicSite;

use App\Http\Controllers\Controller;
use App\Models\Pengumuman;
use App\Models\JadwalIbadah;
use App\Models\Berita;

class BerandaController extends Controller
{
    private $hariMap = [
        'Minggu' => 'Sunday',
        'Senin' => 'Monday',
        'Selasa' => 'Tuesday',
        'Rabu' => 'Wednesday',
        'Kamis' => 'Thursday',
        'Jumat' => 'Friday',
        'Sabtu' => 'Saturday',
    ];

    public function index()
    {
        $pengumumanData = Pengumuman::terbaru(3)->get();
        $pengumuman = $pengumumanData->map(function ($item) {
            return [
                'judul' => $item->judul,
                'deskripsi' => $item->deskripsi,
                'tanggal' => $item->tanggal->translatedFormat('d M Y'),
            ];
        })->toArray();

        $jadwalData = JadwalIbadah::mingguan()->take(2)->get();
        $jadwalMingguIni = $jadwalData->map(function ($item) {
            $hariEnglish = $this->hariMap[$item->hari] ?? 'Sunday';
            return [
                'nama' => $item->nama,
                'hari' => $item->hari,
                'tanggal' => now()->next($hariEnglish)->format('d M Y'),
                'waktu' => $item->waktu,
                'tempat' => $item->tempat,
            ];
        })->toArray();

        $beritaList = Berita::published()
            ->orderBy('tanggal_publikasi', 'desc')
            ->paginate(9);

        return view('public.beranda', compact('pengumuman', 'jadwalMingguIni', 'beritaList'));
    }
}
