<?php

namespace App\Http\Controllers\PublicSite;

use App\Http\Controllers\Controller;
use App\Models\Berita;

class BeritaController extends Controller
{
    public function index()
    {
        $beritaList = Berita::published()
            ->orderBy('tanggal_publikasi', 'desc')
            ->paginate(9);

        return view('public.berita.index', compact('beritaList'));
    }

    public function show($slug)
    {
        $berita = Berita::where('slug', $slug)
            ->published()
            ->firstOrFail();

        $beritaLainnya = Berita::published()
            ->where('id', '!=', $berita->id)
            ->orderBy('tanggal_publikasi', 'desc')
            ->limit(3)
            ->get();

        return view('public.berita.show', compact('berita', 'beritaLainnya'));
    }
}
