<?php

namespace App\Http\Controllers\PublicSite;

use App\Http\Controllers\Controller;
use App\Models\Donasi;
use App\Models\RekeningBank;
use Illuminate\Http\Request;

class DonasiController extends Controller
{
    public function index()
    {
        $rekeningList = RekeningBank::getAktif();
        return view('public.donasi', compact('rekeningList'));
    }

    public function konfirmasi(Request $request)
    {
        $request->validate([
            'nama' => 'required|string|max:255',
            'telepon' => 'required|string|max:20',
            'jumlah' => 'required|numeric|min:0',
            'tujuan' => 'required|in:persembahan,diakonia,pembangunan',
            'tanggal_transfer' => 'required|date',
        ]);

        Donasi::create([
            'nama' => $request->nama,
            'telepon' => $request->telepon,
            'jumlah' => $request->jumlah,
            'tujuan' => $request->tujuan,
            'tanggal_transfer' => $request->tanggal_transfer,
        ]);

        return redirect()->route('donasi')->with('success', 'Konfirmasi donasi berhasil dikirim. Terima kasih atas persembahan Anda.');
    }
}
