<?php

namespace App\Http\Controllers\PublicSite;

use App\Http\Controllers\Controller;
use App\Models\FormulirDoa;
use App\Models\FormulirPendaftaran;
use App\Models\FormulirKonseling;
use App\Models\Kegiatan;
use Illuminate\Http\Request;

class FormulirController extends Controller
{
    public function index()
    {
        return view('public.formulir.index');
    }

    public function doa()
    {
        return view('public.formulir.doa');
    }

    public function doaSubmit(Request $request)
    {
        $request->validate([
            'nama' => 'required|string|max:255',
            'telepon' => 'required|string|max:20',
            'kategori' => 'required|string',
            'permohonan' => 'required|string',
        ]);

        $formulir = FormulirDoa::create([
            'kode' => FormulirDoa::generateKode(),
            'nama' => $request->nama,
            'telepon' => $request->telepon,
            'email' => $request->email,
            'kategori' => $request->kategori,
            'permohonan' => $request->permohonan,
            'privasi' => $request->has('privasi'),
        ]);

        return redirect()->route('formulir.index')->with('success', "Permohonan doa berhasil dikirim. Kode: {$formulir->kode}");
    }

    public function pendaftaran()
    {
        $kegiatanData = Kegiatan::khusus()->orderBy('tanggal')->get();
        $kegiatanList = $kegiatanData->map(function ($item) {
            return [
                'id' => $item->id,
                'nama' => $item->nama,
                'tanggal' => $item->tanggal ? $item->tanggal->translatedFormat('d M Y') : '',
            ];
        })->toArray();

        return view('public.formulir.pendaftaran', compact('kegiatanList'));
    }

    public function pendaftaranSubmit(Request $request)
    {
        $request->validate([
            'nama' => 'required|string|max:255',
            'telepon' => 'required|string|max:20',
            'kegiatan' => 'required|string|max:255',
        ]);

        $formulir = FormulirPendaftaran::create([
            'kode' => FormulirPendaftaran::generateKode(),
            'nama' => $request->nama,
            'telepon' => $request->telepon,
            'email' => $request->email,
            'usia' => $request->usia,
            'nama_kegiatan' => $request->kegiatan,
            'catatan' => $request->catatan,
        ]);

        return redirect()->route('formulir.index')->with('success', "Pendaftaran berhasil. Kode: {$formulir->kode}");
    }

    public function konseling()
    {
        return view('public.formulir.konseling');
    }

    public function konselingSubmit(Request $request)
    {
        $request->validate([
            'nama' => 'required|string|max:255',
            'telepon' => 'required|string|max:20',
            'kategori' => 'required|string',
            'gambaran' => 'required|string',
        ]);

        $formulir = FormulirKonseling::create([
            'kode' => FormulirKonseling::generateKode(),
            'nama' => $request->nama,
            'telepon' => $request->telepon,
            'jenis_kelamin' => $request->jenis_kelamin,
            'kategori' => $request->kategori,
            'metode' => $request->metode,
            'waktu_diinginkan' => $request->waktu_diinginkan,
            'gambaran' => $request->gambaran,
        ]);

        return redirect()->route('formulir.index')->with('success', 'Permohonan konseling berhasil dikirim. Kami akan menghubungi Anda.');
    }
}
