<?php

namespace App\Http\Controllers\PublicSite;

use App\Http\Controllers\Controller;
use App\Models\JadwalIbadah;

class JadwalIbadahController extends Controller
{
    public function index()
    {
        $jadwalMingguanData = JadwalIbadah::mingguan()->get();
        $jadwalMingguan = $jadwalMingguanData->map(function ($item) {
            return [
                'nama' => $item->nama,
                'hari' => $item->hari,
                'waktu' => $item->waktu,
                'tempat' => $item->tempat,
                'pelayan' => $item->pelayan,
            ];
        })->toArray();

        $jadwalKhususData = JadwalIbadah::khusus()->orderBy('tanggal')->get();
        $jadwalKhusus = $jadwalKhususData->map(function ($item) {
            return [
                'kategori' => $item->kategori,
                'nama' => $item->nama,
                'tanggal' => $item->tanggal->translatedFormat('d M Y'),
                'waktu' => $item->waktu,
                'tempat' => $item->tempat,
                'pelayan' => $item->pelayan,
            ];
        })->toArray();

        return view('public.jadwal-ibadah', compact('jadwalMingguan', 'jadwalKhusus'));
    }
}
