<?php

namespace App\Http\Controllers\PublicSite;

use App\Http\Controllers\Controller;
use App\Models\Jemaat;
use Illuminate\Http\Request;

class JemaatController extends Controller
{
    public function create()
    {
        return view('public.formulir.jemaat');
    }

    public function store(Request $request)
    {
        $request->validate(
            Jemaat::validationRules(),
            Jemaat::validationMessages()
        );

        $jemaat = Jemaat::create([
            'kode' => Jemaat::generateKode(),
            'nama' => $request->nama,
            'jenis_kelamin' => $request->jenis_kelamin,
            'tempat_lahir' => $request->tempat_lahir,
            'tanggal_lahir' => $request->tanggal_lahir,
            'alamat' => $request->alamat,
            'telepon' => $request->telepon,
            'email' => $request->email,
            'status_pernikahan' => $request->status_pernikahan,
            'pekerjaan' => $request->pekerjaan,
            'status' => 'pending',
            'aktif' => false,
        ]);

        return redirect()->route('formulir.index')->with('success', "Pendaftaran jemaat berhasil dikirim. Kode pendaftaran Anda: {$jemaat->kode}. Silakan tunggu konfirmasi dari admin gereja.");
    }
}
