<?php

namespace App\Http\Controllers\PublicSite;

use App\Http\Controllers\Controller;

class KalenderController extends Controller
{
    public function index()
    {
        $bulan = 'Desember';
        $tahun = 2024;
        
        $kalender = [];
        $startDay = 0; // Minggu
        $daysInMonth = 31;
        
        // Empty days before month starts
        for ($i = 0; $i < $startDay; $i++) {
            $kalender[] = ['tanggal' => '', 'bulan_ini' => false, 'hari_minggu' => false, 'hari_ini' => false, 'events' => []];
        }
        
        // Days of month
        for ($day = 1; $day <= $daysInMonth; $day++) {
            $events = [];
            $dayOfWeek = ($startDay + $day - 1) % 7;
            
            if ($dayOfWeek == 0) { // Sunday
                $events[] = ['nama' => 'Ibadah Minggu', 'warna' => '#1e3a5f'];
            }
            if ($dayOfWeek == 3) { // Wednesday
                $events[] = ['nama' => 'Persekutuan Doa', 'warna' => '#2d5a8a'];
            }
            if ($day == 25) {
                $events[] = ['nama' => 'Natal', 'warna' => '#d4af37'];
            }
            
            $kalender[] = [
                'tanggal' => $day,
                'bulan_ini' => true,
                'hari_minggu' => $dayOfWeek == 0,
                'hari_ini' => $day == 20,
                'events' => $events,
            ];
        }

        $agendaBulanIni = [
            ['nama' => 'Ibadah Minggu', 'hari' => '22', 'bulan_singkat' => 'Des', 'waktu' => '09:00 WIB', 'tempat' => 'Gedung Gereja', 'kategori' => 'Ibadah', 'warna' => '#1e3a5f'],
            ['nama' => 'Perayaan Natal', 'hari' => '25', 'bulan_singkat' => 'Des', 'waktu' => '09:00 WIB', 'tempat' => 'Gedung Gereja', 'kategori' => 'Kegiatan Khusus', 'warna' => '#d4af37'],
            ['nama' => 'Persekutuan Doa', 'hari' => '25', 'bulan_singkat' => 'Des', 'waktu' => '18:00 WIB', 'tempat' => 'Ruang Doa', 'kategori' => 'Ibadah', 'warna' => '#2d5a8a'],
            ['nama' => 'Ibadah Minggu', 'hari' => '29', 'bulan_singkat' => 'Des', 'waktu' => '09:00 WIB', 'tempat' => 'Gedung Gereja', 'kategori' => 'Ibadah', 'warna' => '#1e3a5f'],
        ];

        return view('public.kalender', compact('bulan', 'tahun', 'kalender', 'agendaBulanIni'));
    }
}
