<?php

namespace App\Http\Controllers\PublicSite;

use App\Http\Controllers\Controller;
use App\Models\Kegiatan;

class KegiatanController extends Controller
{
    public function index()
    {
        $rutinData = Kegiatan::rutin()->get();
        $kegiatanRutin = $rutinData->map(function ($item) {
            return [
                'nama' => $item->nama,
                'slug' => $item->slug,
                'jadwal' => $item->jadwal,
                'deskripsi' => $item->deskripsi,
            ];
        })->toArray();

        $khususData = Kegiatan::khusus()->orderBy('tanggal')->get();
        $kegiatanKhusus = $khususData->map(function ($item) {
            return [
                'nama' => $item->nama,
                'kategori' => $item->kategori ?? 'Kegiatan Khusus',
                'tanggal' => $item->tanggal ? $item->tanggal->translatedFormat('d M Y') : '',
                'tanggal_hari' => $item->tanggal ? $item->tanggal->format('d') : '',
                'tanggal_bulan' => $item->tanggal ? $item->tanggal->translatedFormat('M') : '',
                'deskripsi' => $item->deskripsi,
                'waktu' => $item->waktu,
                'tempat' => $item->tempat,
            ];
        })->toArray();

        return view('public.kegiatan.index', compact('kegiatanRutin', 'kegiatanKhusus'));
    }

    public function show($slug)
    {
        $kegiatanModel = Kegiatan::where('slug', $slug)->firstOrFail();
        $kegiatan = [
            'nama' => $kegiatanModel->nama,
            'slug' => $kegiatanModel->slug,
            'jadwal' => $kegiatanModel->jadwal,
            'deskripsi' => $kegiatanModel->deskripsi,
            'tanggal' => $kegiatanModel->jadwal ?? ($kegiatanModel->tanggal ? $kegiatanModel->tanggal->translatedFormat('d M Y') : ''),
            'waktu' => $kegiatanModel->waktu,
            'tempat' => $kegiatanModel->tempat,
            'dokumentasi' => $kegiatanModel->dokumentasi ?? [],
        ];

        return view('public.kegiatan.show', compact('kegiatan'));
    }
}
