<?php

namespace App\Http\Controllers\PublicSite;

use App\Http\Controllers\Controller;
use App\Models\PesanKontak;
use Illuminate\Http\Request;

class KontakController extends Controller
{
    public function index()
    {
        $jadwalOnline = [
            [
                'nama' => 'Ibadah Minggu Pagi',
                'hari' => 'Minggu',
                'waktu' => '09:00 WIB',
                'deskripsi' => 'Ibadah minggu utama yang disiarkan secara live.',
                'is_live' => false,
                'zoom_link' => 'https://zoom.us/j/1234567890',
                'meet_link' => 'https://meet.google.com/abc-defg-hij',
            ],
            [
                'nama' => 'Persekutuan Doa',
                'hari' => 'Rabu',
                'waktu' => '18:00 WIB',
                'deskripsi' => 'Persekutuan doa bersama secara daring.',
                'is_live' => false,
                'zoom_link' => 'https://zoom.us/j/0987654321',
                'meet_link' => null,
            ],
            [
                'nama' => 'Konseling Online',
                'hari' => 'Sesuai Jadwal',
                'waktu' => 'By Appointment',
                'deskripsi' => 'Konseling pribadi dengan pendeta.',
                'is_live' => false,
                'zoom_link' => null,
                'meet_link' => 'https://meet.google.com/xyz-uvwx-rst',
            ],
        ];

        return view('public.kontak', compact('jadwalOnline'));
    }

    public function submit(Request $request)
    {
        $validated = $request->validate([
            'nama' => 'required|string|max:255',
            'email' => 'required|email|max:255',
            'subjek' => 'required|string|max:255',
            'pesan' => 'required|string|max:5000',
        ]);

        PesanKontak::create($validated);

        return redirect()->route('kontak')->with('success', 'Pesan berhasil dikirim. Kami akan menghubungi Anda segera.');
    }
}
