<?php

namespace App\Http\Controllers\PublicSite;

use App\Http\Controllers\Controller;
use App\Models\Keuangan;

class LaporanKeuanganController extends Controller
{
    public function index()
    {
        $periode = 'Desember 2024';
        $totalPemasukan = Keuangan::getTotalPemasukan($periode);
        $totalPengeluaran = Keuangan::getTotalPengeluaran($periode);
        $saldo = $totalPemasukan - $totalPengeluaran;

        // Chart data berdasarkan 3 bulan terakhir
        $periodes = ['Oktober 2024', 'November 2024', 'Desember 2024'];
        $bulanShort = ['Okt', 'Nov', 'Des'];
        $chartData = [];
        $maxPemasukan = 25000000; // untuk normalisasi persen

        foreach ($periodes as $i => $p) {
            $pemasukan = Keuangan::getTotalPemasukan($p);
            $pengeluaran = Keuangan::getTotalPengeluaran($p);
            $chartData[] = [
                'bulan' => $bulanShort[$i],
                'pemasukan_persen' => $maxPemasukan > 0 ? round(($pemasukan / $maxPemasukan) * 100) : 0,
                'pengeluaran_persen' => $maxPemasukan > 0 ? round(($pengeluaran / $maxPemasukan) * 100) : 0,
            ];
        }

        $pemasukanData = Keuangan::pemasukan()->periode($periode)->get();
        $pemasukan = $pemasukanData->map(function ($item) {
            return [
                'sumber' => $item->keterangan,
                'jumlah' => $item->jumlah,
            ];
        })->toArray();

        $pengeluaranData = Keuangan::pengeluaran()->periode($periode)->get();
        $pengeluaran = $pengeluaranData->map(function ($item) {
            return [
                'keperluan' => $item->keterangan,
                'jumlah' => $item->jumlah,
            ];
        })->toArray();

        return view('public.laporan-keuangan', compact('periode', 'totalPemasukan', 'totalPengeluaran', 'saldo', 'chartData', 'pemasukan', 'pengeluaran'));
    }
}
