<?php

namespace App\Http\Controllers\PublicSite;

use App\Http\Controllers\Controller;
use App\Models\Oig;

class OigController extends Controller
{
    public function index()
    {
        $oigData = Oig::all();
        $oigList = $oigData->map(function ($item) {
            return [
                'nama' => $item->nama,
                'slug' => $item->slug,
                'deskripsi' => $item->deskripsi,
                'ketua' => $item->ketua,
                'jadwal' => $item->jadwal,
                'pengurus' => $item->pengurus,
            ];
        })->toArray();

        return view('public.oig.index', compact('oigList'));
    }

    public function show($slug)
    {
        $oigModel = Oig::where('slug', $slug)->firstOrFail();
        $oig = [
            'nama' => $oigModel->nama,
            'slug' => $oigModel->slug,
            'deskripsi' => $oigModel->deskripsi,
            'ketua' => $oigModel->ketua,
            'jadwal' => $oigModel->jadwal,
            'pengurus' => $oigModel->pengurus,
        ];

        return view('public.oig.show', compact('oig'));
    }
}
