<?php

namespace App\Http\Controllers\PublicSite;

use App\Http\Controllers\Controller;
use App\Models\ProfilGereja;
use App\Models\Pendeta;
use App\Models\Majelis;

class ProfilController extends Controller
{
    public function index()
    {
        $profilModel = ProfilGereja::getProfil();
        $profil = [
            'nama_gereja' => $profilModel->nama_gereja ?? 'Gereja Jemaat Buntu Ambaang',
            'alamat' => $profilModel->alamat ?? '',
            'telepon' => $profilModel->telepon ?? '',
            'email' => $profilModel->email ?? '',
            'tahun_berdiri' => $profilModel->tahun_berdiri ?? '',
            'visi' => $profilModel->visi ?? '',
            'misi' => $profilModel->misi ?? [],
        ];

        $pendetaModel = Pendeta::getPendeta();
        $pendeta = [
            'nama' => $pendetaModel->nama ?? '',
            'jabatan' => $pendetaModel->jabatan ?? 'Pendeta Jemaat',
            'foto' => $pendetaModel->foto_path,
            'telepon' => $pendetaModel->telepon ?? '',
            'email' => $pendetaModel->email ?? '',
            'mulai_melayani' => $pendetaModel->mulai_melayani ?? '',
        ];

        $majelisData = Majelis::ordered()->get();
        $majelis = $majelisData->map(function ($item) {
            return [
                'nama' => $item->nama,
                'jabatan' => $item->jabatan,
                'bidang' => $item->bidang,
                'foto' => $item->foto_path,
            ];
        })->toArray();

        return view('public.profil', compact('profil', 'pendeta', 'majelis'));
    }
}
