<?php

namespace App\Http\Middleware;

use Closure;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;
use Symfony\Component\HttpFoundation\Response;

class AdminOnly
{
    public function handle(Request $request, Closure $next): Response
    {
        if (!Auth::check()) {
            return redirect()->route('admin.login')->with('error', 'Silakan login terlebih dahulu.');
        }

        $user = Auth::user();

        if (!$user->is_active) {
            Auth::logout();
            return redirect()->route('admin.login')->with('error', 'Akun Anda tidak aktif.');
        }

        if (!$user->isAdmin()) {
            if ($user->isPendeta()) {
                return redirect()->route('pendeta.dashboard')->with('error', 'Halaman ini hanya untuk Administrator.');
            }
            return redirect()->route('admin.login')->with('error', 'Anda tidak memiliki akses.');
        }

        return $next($request);
    }
}
