<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class FormulirDoa extends Model
{
    protected $table = 'formulir_doa';

    protected $fillable = [
        'kode',
        'nama',
        'telepon',
        'email',
        'kategori',
        'permohonan',
        'privasi',
        'status',
    ];

    protected $casts = [
        'privasi' => 'boolean',
    ];

    public function notes()
    {
        return $this->morphMany(FormulirNote::class, 'notable')->orderBy('created_at', 'asc');
    }

    public static function generateKode()
    {
        return 'DOA-' . strtoupper(substr(md5(uniqid()), 0, 6));
    }
}
