<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class FormulirKonseling extends Model
{
    protected $table = 'formulir_konseling';

    protected $fillable = [
        'kode',
        'nama',
        'telepon',
        'jenis_kelamin',
        'kategori',
        'metode',
        'waktu_diinginkan',
        'gambaran',
        'status',
    ];

    protected $casts = [
        'waktu_diinginkan' => 'datetime',
    ];

    public function notes()
    {
        return $this->morphMany(FormulirNote::class, 'notable')->orderBy('created_at', 'asc');
    }

    public static function generateKode()
    {
        return 'KSL-' . strtoupper(substr(md5(uniqid()), 0, 6));
    }
}
