<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class FormulirPendaftaran extends Model
{
    protected $table = 'formulir_pendaftaran';

    protected $fillable = [
        'kode',
        'nama',
        'telepon',
        'email',
        'usia',
        'kegiatan_id',
        'nama_kegiatan',
        'catatan',
        'status',
    ];

    protected $casts = [
        'usia' => 'integer',
    ];

    public function notes()
    {
        return $this->morphMany(FormulirNote::class, 'notable')->orderBy('created_at', 'asc');
    }

    public function kegiatan()
    {
        return $this->belongsTo(Kegiatan::class, 'kegiatan_id');
    }

    public static function generateKode()
    {
        return 'REG-' . strtoupper(substr(md5(uniqid()), 0, 6));
    }
}
