<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class JadwalIbadah extends Model
{
    protected $table = 'jadwal_ibadah';

    protected $fillable = [
        'nama',
        'hari',
        'waktu',
        'tempat',
        'pelayan',
        'online',
        'tipe',
        'kategori',
        'tanggal',
        'aktif',
    ];

    protected $casts = [
        'online' => 'boolean',
        'aktif' => 'boolean',
        'tanggal' => 'date',
    ];

    public function scopeMingguan($query)
    {
        return $query->where('tipe', 'mingguan')->where('aktif', true);
    }

    public function scopeKhusus($query)
    {
        return $query->where('tipe', 'khusus')->where('aktif', true);
    }

    public function scopeAktif($query)
    {
        return $query->where('aktif', true);
    }
}
