<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class Kalender extends Model
{
    protected $table = 'kalender';

    protected $fillable = [
        'nama',
        'tanggal',
        'waktu',
        'tipe',
        'deskripsi',
        'tempat',
        'aktif',
    ];

    protected $casts = [
        'tanggal' => 'date',
        'aktif' => 'boolean',
    ];

    public function scopeAktif($query)
    {
        return $query->where('aktif', true);
    }

    public function scopeUpcoming($query)
    {
        return $query->where('tanggal', '>=', now()->startOfDay())->orderBy('tanggal');
    }

    public function scopeByTipe($query, $tipe)
    {
        return $query->where('tipe', $tipe);
    }
}
