<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class Kegiatan extends Model
{
    protected $table = 'kegiatan';

    protected $fillable = [
        'nama',
        'slug',
        'deskripsi',
        'jadwal',
        'waktu',
        'tempat',
        'tipe',
        'kategori',
        'tanggal',
        'dokumentasi',
        'aktif',
    ];

    protected $casts = [
        'dokumentasi' => 'array',
        'aktif' => 'boolean',
        'tanggal' => 'date',
    ];

    public function getRouteKeyName()
    {
        return 'slug';
    }

    public function scopeRutin($query)
    {
        return $query->where('tipe', 'rutin')->where('aktif', true);
    }

    public function scopeKhusus($query)
    {
        return $query->where('tipe', 'khusus')->where('aktif', true);
    }

    public function scopeAktif($query)
    {
        return $query->where('aktif', true);
    }

    public function pendaftaran()
    {
        return $this->hasMany(FormulirPendaftaran::class, 'kegiatan_id');
    }
}
