<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class Keuangan extends Model
{
    protected $table = 'keuangan';

    protected $fillable = [
        'tipe',
        'kategori',
        'keterangan',
        'jumlah',
        'tanggal',
        'periode',
    ];

    protected $casts = [
        'jumlah' => 'decimal:2',
        'tanggal' => 'date',
    ];

    public function scopePemasukan($query)
    {
        return $query->where('tipe', 'pemasukan');
    }

    public function scopePengeluaran($query)
    {
        return $query->where('tipe', 'pengeluaran');
    }

    public function scopePeriode($query, $periode)
    {
        return $query->where('periode', $periode);
    }

    public static function getTotalPemasukan($periode = null)
    {
        $query = self::pemasukan();
        if ($periode) {
            $query->periode($periode);
        }
        return $query->sum('jumlah');
    }

    public static function getTotalPengeluaran($periode = null)
    {
        $query = self::pengeluaran();
        if ($periode) {
            $query->periode($periode);
        }
        return $query->sum('jumlah');
    }
}
