<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Support\Facades\File;

class Majelis extends Model
{
    protected $table = 'majelis';

    protected $fillable = [
        'nama',
        'jabatan',
        'bidang',
        'foto',
        'urutan',
    ];

    public function getFotoPathAttribute()
    {
        if ($this->foto && File::exists(public_path('images/' . $this->foto))) {
            return $this->foto;
        }
        return null;
    }

    public function scopeOrdered($query)
    {
        return $query->orderBy('urutan')->orderBy('id');
    }
}
