<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class Oig extends Model
{
    protected $table = 'oig';

    protected $fillable = [
        'nama',
        'slug',
        'deskripsi',
        'ketua',
        'jadwal',
        'pengurus',
    ];

    protected $casts = [
        'pengurus' => 'array',
    ];

    /**
     * Normalize pengurus data format on the fly.
     * 
     * Handles legacy format: {"Ketua": "Nama"}
     * Converts to new format: [{"nama": "Nama", "jabatan": "Ketua"}]
     */
    public function getPengurusAttribute($value)
    {
        $data = json_decode($value, true);

        if (empty($data)) {
            return [];
        }

        // Check if it's the legacy format (associative array where keys are jabatans)
        // New format is a list of arrays: [[ "nama" => "...", "jabatan" => "..." ]]
        if (array_keys($data) !== range(0, count($data) - 1)) {
            $normalized = [];
            foreach ($data as $jabatan => $nama) {
                // If the value is a string, it's definitely the legacy format
                if (is_string($nama)) {
                    $normalized[] = [
                        'nama' => $nama,
                        'jabatan' => $jabatan,
                    ];
                } else {
                    // Fallback for cases where it's already an array but index-based
                    return $data;
                }
            }
            return $normalized;
        }

        return $data;
    }

    public function getRouteKeyName()
    {
        return 'slug';
    }
}
