<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Support\Facades\File;

class Pendeta extends Model
{
    protected $table = 'pendeta';

    protected $fillable = [
        'nama',
        'jabatan',
        'telepon',
        'email',
        'mulai_melayani',
        'foto',
    ];

    public static function getPendeta()
    {
        return self::first() ?? new self();
    }

    public function getFotoPathAttribute()
    {
        if ($this->foto && File::exists(public_path('images/' . $this->foto))) {
            return $this->foto;
        }
        return null;
    }
}
