<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class PesanKontak extends Model
{
    protected $table = 'pesan_kontak';

    protected $fillable = [
        'nama',
        'email',
        'subjek',
        'pesan',
        'dibaca',
        'dibaca_at',
    ];

    protected $casts = [
        'dibaca' => 'boolean',
        'dibaca_at' => 'datetime',
    ];

    public function scopeBelumDibaca($query)
    {
        return $query->where('dibaca', false);
    }

    public function scopeSudahDibaca($query)
    {
        return $query->where('dibaca', true);
    }

    public function scopeTerbaru($query)
    {
        return $query->orderBy('created_at', 'desc');
    }

    public function tandaiDibaca()
    {
        $this->update([
            'dibaca' => true,
            'dibaca_at' => now(),
        ]);
    }

    public function tandaiBelumDibaca()
    {
        $this->update([
            'dibaca' => false,
            'dibaca_at' => null,
        ]);
    }

    public static function jumlahBelumDibaca()
    {
        return self::belumDibaca()->count();
    }
}
