<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class RekeningBank extends Model
{
    protected $table = 'rekening_bank';

    protected $fillable = [
        'nama_bank',
        'nomor_rekening',
        'atas_nama',
        'kode_bank',
        'is_primary',
        'aktif',
        'urutan',
    ];

    protected $casts = [
        'is_primary' => 'boolean',
        'aktif' => 'boolean',
    ];

    public function scopeAktif($query)
    {
        return $query->where('aktif', true);
    }

    public function scopeOrdered($query)
    {
        return $query->orderBy('is_primary', 'desc')->orderBy('urutan');
    }

    public static function getAktif()
    {
        return self::aktif()->ordered()->get();
    }
}
