<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up(): void
    {
        Schema::create('profil_gereja', function (Blueprint $table) {
            $table->id();
            $table->string('nama_gereja');
            $table->text('alamat');
            $table->string('telepon', 20)->nullable();
            $table->string('email')->nullable();
            $table->year('tahun_berdiri')->nullable();
            $table->text('visi')->nullable();
            $table->json('misi')->nullable();
            $table->timestamps();
        });
    }

    public function down(): void
    {
        Schema::dropIfExists('profil_gereja');
    }
};
