<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up(): void
    {
        Schema::create('pendeta', function (Blueprint $table) {
            $table->id();
            $table->string('nama');
            $table->string('jabatan')->default('Pendeta Jemaat');
            $table->string('telepon', 20)->nullable();
            $table->string('email')->nullable();
            $table->string('mulai_melayani', 10)->nullable();
            $table->string('foto')->nullable();
            $table->timestamps();
        });
    }

    public function down(): void
    {
        Schema::dropIfExists('pendeta');
    }
};
