<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up(): void
    {
        Schema::create('jadwal_ibadah', function (Blueprint $table) {
            $table->id();
            $table->string('nama');
            $table->string('hari');
            $table->string('waktu', 10);
            $table->string('tempat');
            $table->string('pelayan')->nullable();
            $table->boolean('online')->default(false);
            $table->enum('tipe', ['mingguan', 'khusus'])->default('mingguan');
            $table->string('kategori')->nullable();
            $table->date('tanggal')->nullable();
            $table->boolean('aktif')->default(true);
            $table->timestamps();
        });
    }

    public function down(): void
    {
        Schema::dropIfExists('jadwal_ibadah');
    }
};
