<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up(): void
    {
        Schema::create('kegiatan', function (Blueprint $table) {
            $table->id();
            $table->string('nama');
            $table->string('slug')->unique();
            $table->text('deskripsi')->nullable();
            $table->string('jadwal')->nullable();
            $table->string('waktu', 20)->nullable();
            $table->string('tempat')->nullable();
            $table->enum('tipe', ['rutin', 'khusus'])->default('rutin');
            $table->string('kategori')->nullable();
            $table->date('tanggal')->nullable();
            $table->json('dokumentasi')->nullable();
            $table->boolean('aktif')->default(true);
            $table->timestamps();
        });
    }

    public function down(): void
    {
        Schema::dropIfExists('kegiatan');
    }
};
