<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up(): void
    {
        Schema::create('formulir_konseling', function (Blueprint $table) {
            $table->id();
            $table->string('kode')->unique();
            $table->string('nama');
            $table->string('telepon', 20);
            $table->enum('jenis_kelamin', ['laki-laki', 'perempuan'])->nullable();
            $table->string('kategori');
            $table->enum('metode', ['tatap_muka', 'online', 'telepon'])->nullable();
            $table->datetime('waktu_diinginkan')->nullable();
            $table->text('gambaran');
            $table->enum('status', ['pending', 'dijadwalkan', 'selesai', 'batal'])->default('pending');
            $table->timestamps();
        });
    }

    public function down(): void
    {
        Schema::dropIfExists('formulir_konseling');
    }
};
