<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up(): void
    {
        Schema::create('komunikasi', function (Blueprint $table) {
            $table->id();
            $table->string('nama');
            $table->text('deskripsi')->nullable();
            $table->string('hari');
            $table->date('tanggal')->nullable();
            $table->time('waktu');
            $table->string('platform');
            $table->string('zoom_link')->nullable();
            $table->string('meet_link')->nullable();
            $table->boolean('is_active')->default(false);
            $table->text('catatan')->nullable();
            $table->timestamps();
        });
    }

    public function down(): void
    {
        Schema::dropIfExists('komunikasi');
    }
};
