<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up(): void
    {
        Schema::create('berita', function (Blueprint $table) {
            $table->id();
            $table->string('judul');
            $table->string('slug')->unique();
            $table->text('ringkasan')->nullable();
            $table->longText('isi');
            $table->string('gambar')->nullable();
            $table->date('tanggal_publikasi');
            $table->enum('status', ['draft', 'published'])->default('draft');
            $table->boolean('aktif')->default(true);
            $table->unsignedBigInteger('author_id')->nullable();
            $table->timestamps();
            
            $table->foreign('author_id')->references('id')->on('users')->onDelete('set null');
            $table->index(['status', 'tanggal_publikasi']);
        });
    }

    public function down(): void
    {
        Schema::dropIfExists('berita');
    }
};
